/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NegatedIfElseInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;
    public boolean m_ignoreNegatedZeroComparison = false;

    @NotNull
    public String getID() {
        if ("IfStatementWithNegatedCondition" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedIfElseInspection", "getID"));
        }
        return "IfStatementWithNegatedCondition";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.if.else.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedIfElseInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.if.else.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedIfElseInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedIfElseVisitor();
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("negated.if.else.ignore.negated.null.option", new Object[0]), "m_ignoreNegatedNullComparison");
        panel2.addCheckbox(InspectionGadgetsBundle.message("negated.if.else.ignore.negated.zero.option", new Object[0]), "m_ignoreNegatedZeroComparison");
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedIfElseFix();
    }

    private class NegatedIfElseVisitor
    extends BaseInspectionVisitor {
        private NegatedIfElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement2);
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement2.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                return;
            }
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            if (!ExpressionUtils.isNegation(condition2, NegatedIfElseInspection.this.m_ignoreNegatedNullComparison, NegatedIfElseInspection.this.m_ignoreNegatedZeroComparison)) {
                return;
            }
            PsiElement parent = statement2.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }

    private static class NegatedIfElseFix
    extends InspectionGadgetsFix {
        private NegatedIfElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.if.else.invert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiComment comment;
            IElementType tokenType;
            PsiElement ifToken = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifToken.getParent();
            assert (ifStatement != null);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition2);
            String elseText = elseBranch.getText();
            PsiElement lastChild = elseBranch.getLastChild();
            if (lastChild instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType = (comment = (PsiComment)lastChild).getTokenType())) {
                elseText = elseText + '\n';
            }
            String newStatement = "if(" + negatedCondition + ')' + elseText + " else " + thenBranch.getText();
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatement);
        }
    }
}

