/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class PointlessIndexOfComparisonInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.indexof.comparison.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiBinaryExpression expression2 = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = expression2.getLOperand();
        PsiJavaToken sign = expression2.getOperationSign();
        boolean value2 = lhs instanceof PsiMethodCallExpression ? PointlessIndexOfComparisonInspection.createContainsExpressionValue(sign, false) : PointlessIndexOfComparisonInspection.createContainsExpressionValue(sign, true);
        if (value2) {
            String string = InspectionGadgetsBundle.message("pointless.indexof.comparison.always.true.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("pointless.indexof.comparison.always.false.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection", "buildErrorString"));
        }
        return string;
    }

    static boolean createContainsExpressionValue(@NotNull PsiJavaToken sign, boolean flipped) {
        if (sign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection", "createContainsExpressionValue"));
        }
        IElementType tokenType = sign.getTokenType();
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            return false;
        }
        if (tokenType.equals(JavaTokenType.NE)) {
            return true;
        }
        return !(flipped ? tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE) : tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessIndexOfComparisonVisitor();
    }

    private static class PointlessIndexOfComparisonVisitor
    extends BaseInspectionVisitor {
        private PointlessIndexOfComparisonVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            PsiJavaToken sign;
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiJavaToken sign2 = expression2.getOperationSign();
                if (PointlessIndexOfComparisonVisitor.isPointLess(lhs, sign2, rhs, false)) {
                    this.registerError((PsiElement)expression2, expression2);
                }
            } else if (rhs instanceof PsiMethodCallExpression && PointlessIndexOfComparisonVisitor.isPointLess(rhs, sign = expression2.getOperationSign(), lhs, true)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        private static boolean isPointLess(PsiExpression lhs, PsiJavaToken sign, PsiExpression rhs, boolean flipped) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!PointlessIndexOfComparisonVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            IElementType tokenType = sign.getTokenType();
            if (tokenType == null) {
                return false;
            }
            if (flipped) {
                if (constant < 0 && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.LE))) {
                    return true;
                }
                if (constant < -1 && (tokenType.equals(JavaTokenType.GE) || tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.EQEQ))) {
                    return true;
                }
            } else {
                if (constant < 0 && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.GE))) {
                    return true;
                }
                if (constant < -1 && (tokenType.equals(JavaTokenType.LE) || tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.EQEQ))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection$PointlessIndexOfComparisonVisitor", "isIndexOfCall"));
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            return "indexOf".equals(methodName);
        }
    }
}

