/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableEqualsExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.equals.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("simplifiable.equals.expression.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableEqualsExpressionFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableEqualsExpressionVisitor();
    }

    private static class SimplifiableEqualsExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableEqualsExpressionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                PsiExpression[] operands2 = expression2.getOperands();
                if (operands2.length != 2) {
                    return;
                }
                PsiExpression lhs = operands2[0];
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(lhs, false);
                if (variable == null) {
                    return;
                }
                PsiExpression rhs = ParenthesesUtils.stripParentheses(operands2[1]);
                if (!SimplifiableEqualsExpressionVisitor.isEqualsConstant(rhs, variable)) {
                    return;
                }
                this.registerError((PsiElement)lhs, SimplifiableEqualsExpressionVisitor.getMethodName((PsiMethodCallExpression)rhs));
            } else if (JavaTokenType.OROR.equals(tokenType)) {
                PsiExpression[] operands3 = expression2.getOperands();
                if (operands3.length != 2) {
                    return;
                }
                PsiExpression lhs = operands3[0];
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(lhs, true);
                if (variable == null) {
                    return;
                }
                PsiExpression rhs = ParenthesesUtils.stripParentheses(operands3[1]);
                if (!(rhs instanceof PsiPrefixExpression)) {
                    return;
                }
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)rhs;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                PsiExpression operand2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                if (!SimplifiableEqualsExpressionVisitor.isEqualsConstant(operand2, variable)) {
                    return;
                }
                this.registerError((PsiElement)lhs, SimplifiableEqualsExpressionVisitor.getMethodName((PsiMethodCallExpression)operand2));
            }
        }

        private static String getMethodName(PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            return methodExpression.getReferenceName();
        }

        private static boolean isEqualsConstant(PsiExpression expression2, PsiVariable variable) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName) && !"equalsIgnoreCase".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target2 = referenceExpression.resolve();
            if (!variable.equals(target2)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            return PsiUtil.isConstantExpression((PsiExpression)argument);
        }
    }

    private static class SimplifiableEqualsExpressionFix
    extends InspectionGadgetsFix {
        private final String myMethodName;

        public SimplifiableEqualsExpressionFix(String methodName) {
            this.myMethodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("simplifiable.equals.expression.quickfix", this.myMethodName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection$SimplifiableEqualsExpressionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableEqualsExpressionInspection$SimplifiableEqualsExpressionFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses(element);
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            if (operands2.length != 2) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(operands2[1]);
            StringBuilder newExpressionText = new StringBuilder();
            if (operand2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)operand2;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                newExpressionText.append('!');
                operand2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            }
            if (!(operand2 instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type2 = argument.getType();
            if (PsiType.BOOLEAN.equals((Object)type2)) {
                Object value2 = ExpressionUtils.computeConstantExpression(argument);
                if (Boolean.TRUE.equals(value2)) {
                    newExpressionText.append("java.lang.Boolean.TRUE");
                } else if (Boolean.FALSE.equals(value2)) {
                    newExpressionText.append("java.lang.Boolean.FALSE");
                } else {
                    newExpressionText.append("java.lang.Boolean.valueOf(").append(argument.getText()).append(')');
                }
            } else if (PsiType.BYTE.equals((Object)type2)) {
                newExpressionText.append("java.lang.Byte.valueOf(").append(argument.getText()).append(')');
            } else if (PsiType.SHORT.equals((Object)type2)) {
                newExpressionText.append("java.lang.Short.valueOf(").append(argument.getText()).append(')');
            } else if (PsiType.INT.equals((Object)type2)) {
                newExpressionText.append("java.lang.Integer.valueOf(").append(argument.getText()).append(')');
            } else if (PsiType.LONG.equals((Object)type2)) {
                newExpressionText.append("java.lang.Long.valueOf(").append(argument.getText()).append(')');
            } else if (PsiType.FLOAT.equals((Object)type2)) {
                newExpressionText.append("java.lang.Float.valueOf(").append(argument.getText()).append(')');
            } else if (PsiType.DOUBLE.equals((Object)type2)) {
                newExpressionText.append("java.lang.Double.valueOf(").append(argument.getText()).append(')');
            } else {
                newExpressionText.append(argument.getText());
            }
            newExpressionText.append('.').append(referenceName).append('(').append(qualifier.getText()).append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString());
        }
    }
}

