/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("RedundantConditionalExpression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "getID"));
        }
        return "RedundantConditionalExpression";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacement = (String)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", replacement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = (String)infos[0];
        return new UnnecessaryConditionalFix(replacement);
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            PsiExpression condition2 = ParenthesesUtils.stripParentheses(expression2.getCondition());
            if (condition2 == null) {
                return;
            }
            if (BoolUtils.isFalse(thenExpression2) && BoolUtils.isTrue(elseExpression2)) {
                this.registerError((PsiElement)expression2, BoolUtils.getNegatedExpressionText(condition2));
            } else if (BoolUtils.isTrue(thenExpression2) && BoolUtils.isFalse(elseExpression2)) {
                this.registerError((PsiElement)expression2, condition2.getText());
            } else if (this.isUnnecessary(condition2, thenExpression2, elseExpression2, JavaTokenType.EQEQ)) {
                this.registerError((PsiElement)expression2, elseExpression2.getText());
            } else if (this.isUnnecessary(condition2, elseExpression2, thenExpression2, JavaTokenType.NE)) {
                this.registerError((PsiElement)expression2, thenExpression2.getText());
            }
        }

        boolean isUnnecessary(PsiExpression condition2, PsiExpression thenExpression2, PsiExpression elseExpression2, IElementType expectedToken) {
            if (!(condition2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            IElementType token = binaryExpression.getOperationTokenType();
            if (token != expectedToken) {
                return false;
            }
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return equivalence.expressionsAreEquivalent(thenExpression2, lhs) && equivalence.expressionsAreEquivalent(elseExpression2, rhs) || equivalence.expressionsAreEquivalent(thenExpression2, rhs) && equivalence.expressionsAreEquivalent(elseExpression2, lhs);
        }
    }

    private static class UnnecessaryConditionalFix
    extends InspectionGadgetsFix {
        private final String myReplacement;

        public UnnecessaryConditionalFix(String replacement) {
            this.myReplacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/UnnecessaryConditionalExpressionInspection$UnnecessaryConditionalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor.getPsiElement();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, this.myReplacement);
        }
    }
}

