/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class BooleanVariableAlwaysNegatedInspectionBase
extends BaseInspection {
    BooleanVariableAlwaysNegatedInspectionBase() {
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.variable.always.inverted.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/BooleanVariableAlwaysNegatedInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        if (variable instanceof PsiField) {
            String string = InspectionGadgetsBundle.message("boolean.field.always.inverted.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/BooleanVariableAlwaysNegatedInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("boolean.variable.always.inverted.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/BooleanVariableAlwaysNegatedInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanVariableAlwaysNegatedVisitor();
    }

    private static class AlwaysNegatedVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable variable;
        private boolean alwaysNegated = true;
        private boolean read;

        AlwaysNegatedVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (!this.alwaysNegated) {
                return;
            }
            String referenceName = expression2.getReferenceName();
            if (referenceName == null) {
                return;
            }
            if (!referenceName.equals(this.variable.getName())) {
                return;
            }
            PsiElement target2 = expression2.resolve();
            if (!this.variable.equals(target2)) {
                return;
            }
            if (!PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
                return;
            }
            this.read = true;
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiPrefixExpression)) {
                this.alwaysNegated = false;
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                this.alwaysNegated = false;
            }
        }

        boolean isAlwaysNegated() {
            return this.alwaysNegated;
        }

        public boolean isRead() {
            return this.read;
        }
    }

    private static class BooleanVariableAlwaysNegatedVisitor
    extends BaseInspectionVisitor {
        private BooleanVariableAlwaysNegatedVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (!BooleanVariableAlwaysNegatedVisitor.isAlwaysInvertedBoolean((PsiVariable)field, (PsiElement)field.getContainingClass())) {
                return;
            }
            this.registerVariableError((PsiVariable)field, field);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!BooleanVariableAlwaysNegatedVisitor.isAlwaysInvertedBoolean((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, variable);
        }

        private static boolean isAlwaysInvertedBoolean(@NotNull PsiVariable field, PsiElement context) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/dataflow/BooleanVariableAlwaysNegatedInspectionBase$BooleanVariableAlwaysNegatedVisitor", "isAlwaysInvertedBoolean"));
            }
            if (context == null) {
                return false;
            }
            PsiType type2 = field.getType();
            if (!PsiType.BOOLEAN.equals((Object)type2)) {
                return false;
            }
            AlwaysNegatedVisitor visitor = new AlwaysNegatedVisitor(field);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isRead() && visitor.isAlwaysNegated();
        }
    }
}

