/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantValueVariableUseInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.value.variable.use.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        return new ReplaceReferenceWithExpressionFix(expression2.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantValueVariableUseVisitor();
    }

    private static class VariableReadVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiVariable variable;
        private boolean read;
        private boolean stop;
        private PsiReferenceExpression reference;

        VariableReadVisitor(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor", "<init>"));
            }
            this.read = false;
            this.stop = false;
            this.reference = null;
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$VariableReadVisitor", "visitElement"));
            }
            if (this.read || this.stop) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.read || this.stop) {
                return;
            }
            PsiElement target2 = expression2.resolve();
            if (this.variable.equals(target2)) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    this.stop = true;
                    return;
                }
                if (PsiUtil.isAccessedForReading((PsiExpression)expression2)) {
                    if (VariableReadVisitor.isInLoopCondition((PsiExpression)expression2)) {
                        this.stop = true;
                    } else {
                        this.reference = expression2;
                        this.read = true;
                    }
                    return;
                }
            }
            super.visitReferenceExpression(expression2);
        }

        private static boolean isInLoopCondition(PsiExpression expression2) {
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            return statement2 instanceof PsiLoopStatement;
        }

        public boolean isRead() {
            return this.read;
        }

        public PsiReferenceExpression getReference() {
            return this.reference;
        }
    }

    private static class ConstantValueVariableUseVisitor
    extends BaseInspectionVisitor {
        private ConstantValueVariableUseVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            PsiStatement body2 = statement2.getThenBranch();
            this.checkCondition(condition2, body2);
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            PsiStatement body2 = statement2.getBody();
            this.checkCondition(condition2, body2);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            PsiStatement body2 = statement2.getBody();
            this.checkCondition(condition2, body2);
        }

        private boolean checkCondition(@Nullable PsiExpression condition2, @Nullable PsiStatement body2) {
            if (body2 == null) {
                return false;
            }
            if (!(condition2 instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND == tokenType) {
                for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                    if (!this.checkCondition(operand2, body2)) continue;
                    return true;
                }
                return false;
            }
            if (JavaTokenType.EQEQ != tokenType) {
                return false;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            if (operands2.length != 2) {
                return false;
            }
            PsiExpression lhs = operands2[0];
            PsiExpression rhs = operands2[1];
            if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                return this.checkConstantValueVariableUse(rhs, lhs, (PsiElement)body2);
            }
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return this.checkConstantValueVariableUse(lhs, rhs, (PsiElement)body2);
            }
            return false;
        }

        private boolean checkConstantValueVariableUse(@Nullable PsiExpression expression2, @NotNull PsiExpression constantExpression, @NotNull PsiElement body2) {
            if (constantExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpression", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor", "checkConstantValueVariableUse"));
            }
            if (body2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ConstantValueVariableUseVisitor", "checkConstantValueVariableUse"));
            }
            PsiType constantType = constantExpression.getType();
            if (PsiType.DOUBLE.equals((Object)constantType)) {
                Object result2 = ExpressionUtils.computeConstantExpression(constantExpression, false);
                if (Double.valueOf(0.0).equals(result2) || Double.valueOf(-0.0).equals(result2)) {
                    return false;
                }
            }
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target2 = referenceExpression.resolve();
            if (!(target2 instanceof PsiVariable)) {
                return false;
            }
            if (target2 instanceof PsiField) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target2;
            VariableReadVisitor visitor = new VariableReadVisitor(variable);
            body2.accept((PsiElementVisitor)visitor);
            if (!visitor.isRead()) {
                return false;
            }
            this.registerError((PsiElement)visitor.getReference(), constantExpression);
            return true;
        }
    }

    private static class ReplaceReferenceWithExpressionFix
    extends InspectionGadgetsFix {
        private final String myText;

        ReplaceReferenceWithExpressionFix(String text2) {
            this.myText = text2;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("replace.reference.with.expression.quickfix", this.myText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/ConstantValueVariableUseInspection$ReplaceReferenceWithExpressionFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            PsiReplacementUtil.replaceExpression(expression2, this.myText);
        }
    }
}

