/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LawOfDemeterInspection
extends BaseInspection {
    public boolean ignoreLibraryCalls = true;
    private static final Key<Integer> key = Key.create((String)"LawOfDemeterInspection");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("law.of.demeter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/LawOfDemeterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("law.of.demeter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/dataflow/LawOfDemeterInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("law.of.demeter.ignore.library.calls.option", new Object[0]), (InspectionProfileEntry)this, "ignoreLibraryCalls");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LawOfDemeterVisitor();
    }

    private class LawOfDemeterVisitor
    extends BaseInspectionVisitor {
        private static final int threshold = 2;

        private LawOfDemeterVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (LawOfDemeterInspection.this.ignoreLibraryCalls && LibraryUtil.callOnLibraryMethod(expression2)) {
                return;
            }
            expression2.putUserData(key, (Object)1);
            this.checkParents((PsiExpression)expression2, 1);
        }

        public void checkParents(PsiExpression expression2, Integer count) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiLocalVariable) {
                Integer localCount = (Integer)expression2.getUserData(key);
                parent.putUserData(key, (Object)localCount);
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiLocalVariable)) {
                    return;
                }
                Integer localCount = (Integer)expression2.getUserData(key);
                element.putUserData(key, (Object)localCount);
            } else if (parent instanceof PsiReferenceExpression) {
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                Integer userData = (Integer)grandParent.getUserData(key);
                if (userData == null) {
                    return;
                }
                int localCount = userData;
                int newCount = localCount + count;
                if (newCount == 2) {
                    this.registerMethodCallError(methodCallExpression, new Object[0]);
                }
                grandParent.putUserData(key, (Object)newCount);
                this.checkParents((PsiExpression)methodCallExpression, count);
            }
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiLocalVariable)) {
                return;
            }
            Integer count = (Integer)element.getUserData(key);
            if (count != null) {
                this.checkParents((PsiExpression)expression2, count);
            }
        }
    }
}

