/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BadExceptionThrownInspectionBase
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.Throwable", "java.lang.Exception", "java.lang.Error", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ClassCastException", "java.lang.ArrayIndexOutOfBoundsException");

    public BadExceptionThrownInspectionBase() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            for (String string : strings) {
                this.exceptions.add(string);
            }
            this.exceptionsString = "";
        }
    }

    @NotNull
    public String getID() {
        if ("ProhibitedExceptionThrown" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/BadExceptionThrownInspectionBase", "getID"));
        }
        return "ProhibitedExceptionThrown";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.exception.thrown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/BadExceptionThrownInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String exceptionName = type2.getPresentableText();
        String string = InspectionGadgetsBundle.message("bad.exception.thrown.problem.descriptor", exceptionName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/BadExceptionThrownInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionThrownVisitor();
    }

    private class BadExceptionThrownVisitor
    extends BaseInspectionVisitor {
        private BadExceptionThrownVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression exception = statement2.getException();
            if (exception == null) {
                return;
            }
            PsiType type2 = exception.getType();
            if (type2 == null) {
                return;
            }
            String text2 = type2.getCanonicalText();
            if (BadExceptionThrownInspectionBase.this.exceptions.contains(text2)) {
                this.registerStatementError((PsiStatement)statement2, type2);
            }
        }
    }
}

