/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ContinueOrBreakFromFinallyBlockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("continue.or.break.from.finally.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ContinueOrBreakFromFinallyBlockInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("continue.or.break.from.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ContinueOrBreakFromFinallyBlockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ContinueOrBreakFromFinallyBlockVisitor();
    }

    private static class ContinueOrBreakFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ContinueOrBreakFromFinallyBlockVisitor() {
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/ContinueOrBreakFromFinallyBlockInspection$ContinueOrBreakFromFinallyBlockVisitor", "visitContinueStatement"));
            }
            super.visitContinueStatement(statement2);
            if (!ControlFlowUtils.isInFinallyBlock((PsiElement)statement2)) {
                return;
            }
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock((PsiElement)continuedStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/ContinueOrBreakFromFinallyBlockInspection$ContinueOrBreakFromFinallyBlockVisitor", "visitBreakStatement"));
            }
            super.visitBreakStatement(statement2);
            if (!ControlFlowUtils.isInFinallyBlock((PsiElement)statement2)) {
                return;
            }
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock((PsiElement)exitedStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }
}

