/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class ErrorRethrownInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ErrorNotRethrown" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ErrorRethrownInspection", "getID"));
        }
        return "ErrorNotRethrown";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("error.rethrown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ErrorRethrownInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("error.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ErrorRethrownInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ErrorRethrownVisitor();
    }

    private static class ErrorRethrownVisitor
    extends BaseInspectionVisitor {
        private ErrorRethrownVisitor() {
        }

        public void visitCatchSection(PsiCatchSection section) {
            super.visitCatchSection(section);
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock == null) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (!ErrorRethrownVisitor.hasJavaLangErrorType(type2) || ExceptionUtils.isThrowableRethrown(parameter, catchBlock)) {
                return;
            }
            this.registerVariableError((PsiVariable)parameter, new Object[0]);
        }

        private static boolean hasJavaLangErrorType(PsiType type2) {
            PsiClassType classType;
            PsiClass aClass;
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (!ErrorRethrownVisitor.hasJavaLangErrorType(disjunction)) continue;
                    return true;
                }
            } else if (type2 instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)(aClass = (classType = (PsiClassType)type2).resolve()), (String)"java.lang.Error") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.ThreadDeath")) {
                return true;
            }
            return false;
        }
    }
}

