/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class AddThisQualifierFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("add.this.qualifier.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/AddThisQualifierFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiReferenceExpression expression2 = (PsiReferenceExpression)descriptor.getPsiElement();
        if (expression2.getQualifierExpression() != null) {
            return;
        }
        PsiExpression thisQualifier = ExpressionUtils.getQualifierOrThis(expression2);
        String newExpression = thisQualifier.getText() + "." + expression2.getText();
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression2, newExpression);
    }
}

