/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameFix
extends RefactoringInspectionGadgetsFix {
    private final String m_targetName;
    private boolean m_searchInStrings = true;
    private boolean m_searchInNonJavaFiles = true;

    public RenameFix() {
        this.m_targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.m_targetName = targetName;
    }

    public RenameFix(@NonNls String targetName, boolean searchInStrings, boolean searchInNonJavaFiles) {
        this.m_targetName = targetName;
        this.m_searchInStrings = searchInStrings;
        this.m_searchInNonJavaFiles = searchInNonJavaFiles;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RenameFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        if (this.m_targetName == null) {
            String string = InspectionGadgetsBundle.message("rename.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RenameFix", "getName"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("renameto.quickfix", this.m_targetName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RenameFix", "getName"));
        }
        return string;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createRenameHandler();
        if (refactoringActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RenameFix", "getHandler"));
        }
        return refactoringActionHandler;
    }

    @Override
    public void doFix(Project project2, ProblemDescriptor descriptor) {
        if (this.m_targetName == null) {
            super.doFix(project2, descriptor);
        } else {
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PsiElement elementToRename = nameIdentifier.getParent();
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project2);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.m_targetName, this.m_searchInStrings, this.m_searchInNonJavaFiles);
            renameRefactoring.run();
        }
    }
}

