/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspectionBase
extends BaseInspection {
    public boolean ignoreEmptySuperMethods;
    final ExternalizableStringSet annotations = new ExternalizableStringSet("javax.annotation.OverridingMethodsMustInvokeSuper");
    boolean onlyReportWhenAnnotated = true;

    @NotNull
    public String getID() {
        if ("MethodDoesntCallSuperMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "getID"));
        }
        return "MethodDoesntCallSuperMethod";
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.onlyReportWhenAnnotated) {
            node.addContent(new Element("option").setAttribute("name", "onlyReportWhenAnnotated").setAttribute("value", String.valueOf(this.onlyReportWhenAnnotated)));
        }
        if (!this.annotations.hasDefaultValues()) {
            Element element = new Element("option").setAttribute("name", "annotations");
            Element valueElement = new Element("value");
            this.annotations.writeExternal(valueElement);
            node.addContent(element.addContent(valueElement));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        this.onlyReportWhenAnnotated = false;
        for (Element option : node.getChildren("option")) {
            Element value2;
            if ("onlyReportWhenAnnotated".equals(option.getAttributeValue("name"))) {
                this.onlyReportWhenAnnotated = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (!"annotations".equals(option.getAttributeValue("name")) || (value2 = option.getChild("value")) == null) continue;
            this.annotations.readExternal(value2);
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/inheritance/RefusedBequestInspectionBase$RefusedBequestVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod leastConcreteSuperMethod = this.getDirectSuperMethod(method);
            if (leastConcreteSuperMethod == null) {
                return;
            }
            String methodName = method.getName();
            if (!"clone".equals(methodName) && (superClass = leastConcreteSuperMethod.getContainingClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            if (RefusedBequestInspectionBase.this.ignoreEmptySuperMethods) {
                PsiMethod superMethod;
                PsiElement element = leastConcreteSuperMethod.getNavigationElement();
                PsiMethod psiMethod = superMethod = element instanceof PsiMethod ? (PsiMethod)element : leastConcreteSuperMethod;
                if (MethodUtils.isTrivial(superMethod, true)) {
                    return;
                }
            }
            if (!(!RefusedBequestInspectionBase.this.onlyReportWhenAnnotated || CloneUtils.isClone(method) || this.isJUnitSetUpOrTearDown(method) || MethodUtils.isFinalize(method) || AnnotationUtil.isAnnotated((PsiModifierListOwner)leastConcreteSuperMethod, (Collection)((Object)RefusedBequestInspectionBase.this.annotations)))) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if ((aClass != null && aClass.hasModifierProperty("final") || method.hasModifierProperty("final")) && MethodUtils.isTrivial(method, true)) {
                return;
            }
            if (MethodCallUtils.containsSuperMethodCall(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isJUnitSetUpOrTearDown(PsiMethod method) {
            String name2 = method.getName();
            if (!"setUp".equals(name2) && !"tearDown".equals(name2)) {
                return false;
            }
            if (method.getParameterList().getParametersCount() != 0) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase");
        }

        @Nullable
        private PsiMethod getDirectSuperMethod(PsiMethod method) {
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null || superMethod.hasModifierProperty("abstract")) {
                return null;
            }
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass == null || containingClass.isInterface()) {
                return null;
            }
            return superMethod;
        }
    }
}

