/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InstanceVariableUninitializedUseInspectionBase
extends BaseInspection {
    protected final List<String> annotationNames = new ArrayList<String>();
    public boolean m_ignorePrimitives = false;
    @NonNls
    public String annotationNamesString = "";

    public InstanceVariableUninitializedUseInspectionBase() {
        InstanceVariableUninitializedUseInspectionBase.parseString(this.annotationNamesString, this.annotationNames);
    }

    @NotNull
    public String getID() {
        if ("InstanceVariableUsedBeforeInitialized" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase", "getID"));
        }
        return "InstanceVariableUsedBeforeInitialized";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        InstanceVariableUninitializedUseInspectionBase.parseString(this.annotationNamesString, this.annotationNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase", "writeSettings"));
        }
        this.annotationNamesString = InstanceVariableUninitializedUseInspectionBase.formatString(this.annotationNames);
        super.writeSettings(element);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, this.annotationNames);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiExpression[] badReads;
            PsiType fieldType;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase$InstanceVariableInitializationVisitor", "visitField"));
            }
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, InstanceVariableUninitializedUseInspectionBase.this.annotationNames);
            if (annotation != null) {
                return;
            }
            if (InstanceVariableUninitializedUseInspectionBase.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (ImplicitUsageProvider provider : (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
                if (!provider.isImplicitWrite((PsiElement)field)) continue;
                return;
            }
            UninitializedReadCollector uninitializedReadsCollector = new UninitializedReadCollector();
            if (!this.isInitializedInInitializer(field, uninitializedReadsCollector)) {
                PsiMethod[] constructors;
                PsiMethod[] psiMethodArray = constructors = aClass.getConstructors();
                int n = psiMethodArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiMethod constructor = psiMethodArray[j];
                    PsiCodeBlock body2 = constructor.getBody();
                    uninitializedReadsCollector.blockAssignsVariable(body2, (PsiVariable)field);
                }
            }
            for (PsiExpression expression2 : badReads = uninitializedReadsCollector.getUninitializedReads()) {
                this.registerError((PsiElement)expression2, field);
            }
        }

        private boolean isInitializedInInitializer(@NotNull PsiField field, UninitializedReadCollector uninitializedReadsCollector) {
            PsiClassInitializer[] initializers;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase$InstanceVariableInitializationVisitor", "isInitializedInInitializer"));
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return false;
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body2;
                if (initializer.hasModifierProperty("static") || !uninitializedReadsCollector.blockAssignsVariable(body2 = initializer.getBody(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }
    }
}

