/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JUnitTestClassNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit.test.class.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnitTestClassNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("junit.test.class.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*Test";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return file2 instanceof PsiClassOwner;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (!(element instanceof PsiClass)) {
                super.visitElement(element);
                return;
            }
            PsiClass aClass = (PsiClass)element;
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            Set frameworks = TestFrameworks.detectApplicableFrameworks((PsiClass)aClass);
            if (frameworks.stream().noneMatch(framework -> framework.getName().startsWith("JUnit") && framework.isTestClass((PsiElement)aClass))) {
                return;
            }
            String name2 = aClass.getName();
            if (name2 == null) {
                return;
            }
            if (JUnitTestClassNamingConventionInspectionBase.this.isValid(name2)) {
                return;
            }
            PsiIdentifier identifier = aClass.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            if (!identifier.isPhysical()) {
                PsiElement navigationElement = identifier.getNavigationElement();
                this.registerError(navigationElement, name2);
            } else {
                this.registerClassError(aClass, name2);
            }
        }
    }
}

