/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForCanBeForeachInspectionBase
extends BaseInspection {
    public boolean REPORT_INDEXED_LOOP = true;
    public boolean ignoreUntypedCollections;

    static boolean isIndexedListLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Number)) {
            return false;
        }
        Number number = (Number)constant;
        if (number.intValue() != 0) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        Holder collectionHolder = ForCanBeForeachInspectionBase.getCollectionFromSizeComparison(condition2, indexVariable, secondDeclaredElement);
        if (collectionHolder == null) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update2)) {
            return false;
        }
        PsiStatement body2 = forStatement.getBody();
        if (!ForCanBeForeachInspectionBase.isIndexVariableOnlyUsedAsListIndex(collectionHolder, indexVariable, body2)) {
            return false;
        }
        if (collectionHolder != Holder.DUMMY) {
            PsiVariable collection = collectionHolder.getVariable();
            PsiClassType collectionType = (PsiClassType)collection.getType();
            PsiType[] parameters2 = collectionType.getParameters();
            if (ignoreUntypedCollections && parameters2.length == 0) {
                return false;
            }
            return !VariableAccessUtils.variableIsAssigned(collection, (PsiElement)body2);
        }
        return true;
    }

    static boolean isArrayLoopStatement(PsiForStatement forStatement) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)constant;
        if (integer != 0) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update2)) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        PsiReferenceExpression arrayReference = ForCanBeForeachInspectionBase.getVariableReferenceFromCondition(condition2, indexVariable, secondDeclaredElement);
        if (arrayReference == null) {
            return false;
        }
        if (!(arrayReference.getType() instanceof PsiArrayType)) {
            return false;
        }
        PsiElement element = arrayReference.resolve();
        if (!(element instanceof PsiVariable)) {
            return false;
        }
        PsiVariable arrayVariable = (PsiVariable)element;
        PsiStatement body2 = forStatement.getBody();
        return body2 == null || ForCanBeForeachInspectionBase.isIndexVariableOnlyUsedAsIndex(arrayVariable, indexVariable, body2) && !VariableAccessUtils.variableIsAssigned(arrayVariable, (PsiElement)body2) && !VariableAccessUtils.arrayContentsAreAssigned(arrayVariable, (PsiElement)body2);
    }

    private static boolean isIndexVariableOnlyUsedAsIndex(@NotNull PsiVariable arrayVariable, @NotNull PsiVariable indexVariable, @Nullable PsiStatement body2) {
        if (arrayVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayVariable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "isIndexVariableOnlyUsedAsIndex"));
        }
        if (indexVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexVariable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "isIndexVariableOnlyUsedAsIndex"));
        }
        if (body2 == null) {
            return true;
        }
        VariableOnlyUsedAsIndexVisitor visitor = new VariableOnlyUsedAsIndexVisitor(arrayVariable, indexVariable);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    private static boolean isIndexVariableOnlyUsedAsListIndex(Holder collectionHolder, PsiVariable indexVariable, PsiStatement body2) {
        if (body2 == null) {
            return true;
        }
        VariableOnlyUsedAsListIndexVisitor visitor = new VariableOnlyUsedAsListIndexVisitor(collectionHolder, indexVariable);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    static boolean isCollectionLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
            return false;
        }
        PsiExpression initialValue = variable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        if (!(initialValue instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
        PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
        String initialCallName = initialMethodExpression.getReferenceName();
        if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
            return false;
        }
        PsiExpressionList argumentList = initialCall.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(initialMethodExpression);
        PsiType qualifierType = qualifier.getType();
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)qualifierType;
        PsiClass qualifierClass = classType.resolve();
        if (ignoreUntypedCollections) {
            PsiClassType type2 = (PsiClassType)variable.getType();
            PsiType[] parameters2 = type2.getParameters();
            PsiType[] parameters1 = classType.getParameters();
            if (parameters2.length == 0 && parameters1.length == 0) {
                return false;
            }
        }
        if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable")) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (!ForCanBeForeachInspectionBase.isHasNext(condition2, variable)) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (update2 != null && !(update2 instanceof PsiEmptyStatement)) {
            return false;
        }
        PsiStatement body2 = forStatement.getBody();
        if (body2 == null) {
            return false;
        }
        if (ForCanBeForeachInspectionBase.calculateCallsToIteratorNext(variable, body2) != 1) {
            return false;
        }
        if (ForCanBeForeachInspectionBase.isIteratorMethodCalled(variable, body2)) {
            return false;
        }
        return !VariableAccessUtils.variableIsReturned(variable, (PsiElement)body2) && !VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body2) && !VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body2);
    }

    private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiStatement body2) {
        if (body2 == null) {
            return 0;
        }
        NumCallsToIteratorNextVisitor visitor = new NumCallsToIteratorNextVisitor(iterator);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.getNumCallsToIteratorNext();
    }

    public static boolean isIteratorMethodCalled(PsiVariable iterator, PsiStatement body2) {
        IteratorMethodCallVisitor visitor = new IteratorMethodCallVisitor(iterator);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.isMethodCalled();
    }

    static boolean isHasNext(PsiExpression condition2, PsiVariable iterator) {
        if (!(condition2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)condition2;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 0) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"hasNext".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target2 = referenceExpression.resolve();
        return iterator.equals(target2);
    }

    @Nullable
    private static PsiReferenceExpression getVariableReferenceFromCondition(PsiExpression condition2, PsiVariable variable, PsiElement secondDeclaredElement) {
        PsiExpression qualifierExpression2;
        PsiReferenceExpression referenceExpression;
        if (!((condition2 = ParenthesesUtils.stripParentheses(condition2)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
        if (rhs == null) {
            return null;
        }
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable) || !(rhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)rhs;
        } else if (tokenType.equals(JavaTokenType.GT)) {
            if (!VariableAccessUtils.evaluatesToVariable(rhs, variable) || !(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)lhs;
        } else {
            return null;
        }
        if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)referenceExpression) == null) {
            PsiElement target2 = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target2)) {
                return null;
            }
            if (target2 instanceof PsiVariable) {
                PsiVariable maxVariable = (PsiVariable)target2;
                PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)maxVariable, PsiCodeBlock.class);
                if (context == null) {
                    return null;
                }
                if (VariableAccessUtils.variableIsAssigned(maxVariable, (PsiElement)context)) {
                    return null;
                }
                PsiExpression expression2 = ParenthesesUtils.stripParentheses(maxVariable.getInitializer());
                if (!(expression2 instanceof PsiReferenceExpression)) {
                    return null;
                }
                referenceExpression = (PsiReferenceExpression)expression2;
                if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)referenceExpression) == null) {
                    return null;
                }
            }
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if ((qualifierExpression2 = referenceExpression.getQualifierExpression()) instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)qualifierExpression2;
        }
        if (qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression || qualifierExpression2 == null) {
            return referenceExpression;
        }
        return null;
    }

    @Nullable
    private static Holder getCollectionFromSizeComparison(PsiExpression condition2, PsiVariable variable, PsiElement secondDeclaredElement) {
        if (!((condition2 = ParenthesesUtils.stripParentheses(condition2)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression rhs = binaryExpression.getROperand();
        PsiExpression lhs = binaryExpression.getLOperand();
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspectionBase.getCollectionFromListMethodCall(rhs, "size", secondDeclaredElement);
        }
        if (tokenType.equals(JavaTokenType.GT)) {
            if (!VariableAccessUtils.evaluatesToVariable(rhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspectionBase.getCollectionFromListMethodCall(lhs, "size", secondDeclaredElement);
        }
        return null;
    }

    static boolean expressionIsListGetLookup(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression reference = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = reference.getMethodExpression();
        PsiElement resolved = methodExpression.resolve();
        if (!(resolved instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolved;
        if (!"get".equals(method.getName())) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.List");
    }

    @Nullable
    private static Holder getCollectionFromListMethodCall(PsiExpression expression2, String methodName, PsiElement secondDeclaredElement) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target2 = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target2)) {
                return null;
            }
            if (!(target2 instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)target2;
            PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (context == null) {
                return null;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context)) {
                return null;
            }
            expression2 = ParenthesesUtils.stripParentheses(variable.getInitializer());
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        if (!methodName.equals(referenceName)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
            return null;
        }
        PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
            return Holder.DUMMY;
        }
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
        PsiElement target3 = referenceExpression.resolve();
        if (!(target3 instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)target3;
        return new Holder(variable);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ForLoopReplaceableByForEach" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "getID"));
        }
        return "ForLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForCanBeForeachVisitor();
    }

    private class ForCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private ForCanBeForeachVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement forStatement) {
            if (forStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$ForCanBeForeachVisitor", "visitForStatement"));
            }
            super.visitForStatement(forStatement);
            if (ForCanBeForeachInspectionBase.isArrayLoopStatement(forStatement) || ForCanBeForeachInspectionBase.isCollectionLoopStatement(forStatement, ForCanBeForeachInspectionBase.this.ignoreUntypedCollections) || ForCanBeForeachInspectionBase.this.REPORT_INDEXED_LOOP && ForCanBeForeachInspectionBase.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspectionBase.this.ignoreUntypedCollections)) {
                this.registerStatementError((PsiStatement)forStatement, new Object[0]);
            }
        }
    }

    private static class Holder {
        public static final Holder DUMMY = new Holder();
        private final PsiVariable variable;

        public Holder(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$Holder", "<init>"));
            }
            this.variable = variable;
        }

        private Holder() {
            this.variable = null;
        }

        public PsiVariable getVariable() {
            return this.variable;
        }
    }

    private static class VariableOnlyUsedAsListIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex;
        private boolean listGetCalled;
        private final PsiVariable indexVariable;
        private final Holder collection;

        private VariableOnlyUsedAsListIndexVisitor(@NotNull Holder collection, @NotNull PsiVariable indexVariable) {
            if (collection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "<init>"));
            }
            if (indexVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexVariable", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "<init>"));
            }
            this.indexVariableUsedOnlyAsIndex = true;
            this.collection = collection;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "visitElement"));
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsListIndexVisitor", "visitReferenceExpression"));
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (this.indexVariable.equals(element)) {
                if (!this.isListIndexExpression(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                } else {
                    this.listGetCalled = true;
                }
            } else if (this.collection == Holder.DUMMY) {
                if (this.isListNonGetMethodCall(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                }
            } else if (this.collection.getVariable().equals(element) && !this.isListReferenceInIndexExpression(reference)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex && this.listGetCalled;
        }

        private boolean isListNonGetMethodCall(PsiReferenceExpression reference) {
            PsiClass containingClass;
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)(containingClass = method.getContainingClass()), (boolean)true)) {
                return false;
            }
            return !this.isListGetExpression(methodCallExpression);
        }

        private boolean isListIndexExpression(PsiReferenceExpression reference) {
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)referenceParent;
            PsiElement parent = expressionList.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListReferenceInIndexExpression(PsiReferenceExpression reference) {
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement greatGrandParent = methodCallExpression.getParent();
            if (greatGrandParent instanceof PsiExpressionStatement) {
                return false;
            }
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListGetExpression(PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                if (this.collection == Holder.DUMMY && (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression)) {
                    return ForCanBeForeachInspectionBase.expressionIsListGetLookup((PsiExpression)methodCallExpression);
                }
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)qualifierExpression2;
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target2 = reference.resolve();
            if (this.collection == Holder.DUMMY || !this.collection.getVariable().equals(target2)) {
                return false;
            }
            return ForCanBeForeachInspectionBase.expressionIsListGetLookup((PsiExpression)methodCallExpression);
        }
    }

    private static class VariableOnlyUsedAsIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex = true;
        private final PsiVariable arrayVariable;
        private final PsiVariable indexVariable;

        private VariableOnlyUsedAsIndexVisitor(PsiVariable arrayVariable, PsiVariable indexVariable) {
            this.arrayVariable = arrayVariable;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsIndexVisitor", "visitElement"));
            }
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            PsiAssignmentExpression assignment;
            PsiExpression lhs;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$VariableOnlyUsedAsIndexVisitor", "visitReferenceExpression"));
            }
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (!this.indexVariable.equals(element)) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiArrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement target2 = referenceExpression.resolve();
            if (!this.arrayVariable.equals(target2)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement arrayExpressionContext = arrayAccessExpression.getParent();
            if (arrayExpressionContext instanceof PsiAssignmentExpression && (lhs = (assignment = (PsiAssignmentExpression)arrayExpressionContext).getLExpression()).equals(arrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex;
        }
    }

    private static class IteratorMethodCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean methodCalled;
        private final PsiVariable iterator;

        private IteratorMethodCallVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$IteratorMethodCallVisitor", "visitElement"));
            }
            if (!this.methodCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$IteratorMethodCallVisitor", "visitMethodCallExpression"));
            }
            if (this.methodCalled) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if ("next".equals(name2)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target2 = referenceExpression.resolve();
            if (this.iterator.equals(target2)) {
                this.methodCalled = true;
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (this.methodCalled) {
                return;
            }
            super.visitMethodReferenceExpression(expression2);
            PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(expression2.getQualifierExpression());
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            if (this.iterator.equals(referenceExpression.resolve())) {
                this.methodCalled = true;
            }
        }

        private boolean isMethodCalled() {
            return this.methodCalled;
        }
    }

    private static class NumCallsToIteratorNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/migration/ForCanBeForeachInspectionBase$NumCallsToIteratorNextVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target2 = referenceExpression.resolve();
            if (!this.iterator.equals(target2)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        private int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }
}

