/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBufferReplaceableByStringBuilderInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getID() {
        if ("StringBufferMayBeStringBuilder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection", "getID"));
        }
        return "StringBufferMayBeStringBuilder";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringBufferMayBeStringBuilderFix();
    }

    @Nullable
    private static PsiNewExpression getNewStringBuffer(PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiNewExpression) {
            return (PsiNewExpression)expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"append".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(qualifier);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringBuilderVisitor();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    private static class StringBufferReplaceableByStringBuilderVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> excludes = ContainerUtil.newHashSet((Object[])new String[]{"java.lang.StringBuilder", "java.lang.StringBuffer"});

        private StringBufferReplaceableByStringBuilderVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            super.visitDeclarationStatement(statement2);
            PsiElement[] declaredElements = statement2.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
                if (StringBufferReplaceableByStringBuilderVisitor.isReplaceableStringBuffer((PsiVariable)variable, context)) continue;
                return;
            }
            PsiLocalVariable firstVariable = (PsiLocalVariable)declaredElements[0];
            this.registerVariableError((PsiVariable)firstVariable, new Object[0]);
        }

        private static boolean isReplaceableStringBuffer(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type2 = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type2)) {
                return false;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return false;
            }
            if (StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(initializer) == null) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context, true)) {
                return false;
            }
            if (VariableAccessUtils.variableIsUsedInInnerClass(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, true, (Processor<PsiCall>)((Processor)call -> {
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                return aClass != null && excludes.contains(aClass.getQualifiedName());
            }));
        }
    }

    private static class StringBufferMayBeStringBuilderFix
    extends InspectionGadgetsFix {
        private StringBufferMayBeStringBuilderFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection$StringBufferMayBeStringBuilderFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement[] declaredElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass stringBuilderClass = psiFacade.findClass("java.lang.StringBuilder", element.getResolveScope());
            if (stringBuilderClass == null) {
                return;
            }
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiJavaCodeReferenceElement stringBuilderClassReference = factory.createClassReferenceElement(stringBuilderClass);
            PsiClassType stringBuilderType = factory.createType(stringBuilderClass);
            PsiTypeElement stringBuilderTypeElement = factory.createTypeElement((PsiType)stringBuilderType);
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)grandParent;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                if (!(declaredElement instanceof PsiVariable)) continue;
                StringBufferMayBeStringBuilderFix.replaceWithStringBuilder(stringBuilderClassReference, stringBuilderTypeElement, (PsiVariable)declaredElement);
            }
        }

        private static void replaceWithStringBuilder(PsiJavaCodeReferenceElement newClassReference, PsiTypeElement newTypeElement, PsiVariable variable) {
            PsiNewExpression initializer = StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(variable.getInitializer());
            if (initializer == null) {
                return;
            }
            PsiNewExpression newExpression = initializer;
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
            if (classReference2 == null) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement != null && typeElement.getParent() == variable) {
                typeElement.replace((PsiElement)newTypeElement);
            }
            classReference2.replace((PsiElement)newClassReference);
        }
    }
}

