/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class BadOddnessInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.oddness.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/BadOddnessInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.oddness.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/BadOddnessInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadOddnessVisitor();
    }

    private static class BadOddnessVisitor
    extends BaseInspectionVisitor {
        private BadOddnessVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/BadOddnessInspection$BadOddnessVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression2);
            if (expression2.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiExpression rhs = expression2.getROperand();
            if (BadOddnessVisitor.isModTwo(lhs) && BadOddnessVisitor.hasValue(rhs, 1)) {
                this.registerError((PsiElement)expression2, expression2);
            }
            if (BadOddnessVisitor.isModTwo(rhs) && BadOddnessVisitor.hasValue(lhs, 1)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        private static boolean isModTwo(PsiExpression exp) {
            if (!(exp instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binary = (PsiBinaryExpression)exp;
            IElementType tokenType = binary.getOperationTokenType();
            if (!JavaTokenType.PERC.equals(tokenType)) {
                return false;
            }
            PsiExpression rhs = binary.getROperand();
            PsiExpression lhs = binary.getLOperand();
            if (rhs == null) {
                return false;
            }
            return BadOddnessVisitor.hasValue(rhs, 2) || BadOddnessVisitor.hasValue(lhs, 2);
        }

        private static boolean hasValue(PsiExpression expression2, int testValue) {
            Integer value2 = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)PsiType.INT);
            return value2 != null && value2 == testValue;
        }
    }
}

