/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import org.jetbrains.annotations.NotNull;

public class OctalAndDecimalIntegersMixedInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("OctalAndDecimalIntegersInSameArray" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalAndDecimalIntegersMixedInspection", "getID"));
        }
        return "OctalAndDecimalIntegersInSameArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("octal.and.decimal.integers.in.same.array.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalAndDecimalIntegersMixedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("octal.and.decimal.integers.in.same.array.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalAndDecimalIntegersMixedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OctalAndDecimalIntegersMixedInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalAndDecimalIntegersMixedVisitor();
    }

    private static class OctalAndDecimalIntegersMixedVisitor
    extends BaseInspectionVisitor {
        private OctalAndDecimalIntegersMixedVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiExpression[] initializers = expression2.getInitializers();
            boolean hasDecimalLiteral = false;
            boolean hasOctalLiteral = false;
            for (PsiExpression initializer : initializers) {
                if (!(initializer instanceof PsiLiteralExpression)) continue;
                PsiLiteralExpression literal = (PsiLiteralExpression)initializer;
                if (OctalAndDecimalIntegersMixedVisitor.isDecimalLiteral(literal)) {
                    hasDecimalLiteral = true;
                }
                if (!OctalAndDecimalIntegersMixedVisitor.isOctalLiteral(literal)) continue;
                hasOctalLiteral = true;
            }
            if (hasOctalLiteral && hasDecimalLiteral) {
                this.registerError((PsiElement)expression2, new Object[0]);
            }
        }

        private static boolean isDecimalLiteral(PsiLiteralExpression literal) {
            PsiType type2 = literal.getType();
            if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
                return false;
            }
            String text2 = literal.getText();
            if ("0".equals(text2)) {
                return false;
            }
            return text2.charAt(0) != '0';
        }

        private static boolean isOctalLiteral(PsiLiteralExpression literal) {
            PsiType type2 = literal.getType();
            if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
                return false;
            }
            String text2 = literal.getText();
            if ("0".equals(text2) || "0L".equals(text2)) {
                return false;
            }
            return text2.charAt(0) == '0' && !text2.startsWith("0x") && !text2.startsWith("0X");
        }
    }
}

