/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuspiciousLiteralUnderscoreInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousLiteralUnderscoreVisitor();
    }

    private static class SuspiciousLiteralUnderscoreVisitor
    extends BaseInspectionVisitor {
        private SuspiciousLiteralUnderscoreVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(PsiType.SHORT.equals((Object)type2) || PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2))) {
                return;
            }
            String text2 = expression2.getText();
            if (text2.startsWith("0") && !text2.startsWith("0.")) {
                return;
            }
            if (!text2.contains("_")) {
                return;
            }
            boolean underscore = false;
            boolean group = false;
            boolean dot = false;
            int digit = 0;
            int index = StringUtil.indexOfAny((String)text2, (String)"fledFLED");
            int length = index > 0 ? index : text2.length();
            for (int i2 = 0; i2 < length; ++i2) {
                char c = text2.charAt(i2);
                if (c == '_' || c == '.') {
                    if (underscore) {
                        return;
                    }
                    underscore = true;
                    if (digit != 3 && group || digit > 3) {
                        this.registerErrorAtOffset((PsiElement)expression2, i2 - digit, digit, new Object[0]);
                    }
                    group = true;
                    digit = 0;
                    if (c != '.') continue;
                    dot = true;
                    continue;
                }
                if (Character.isDigit(c)) {
                    underscore = false;
                    ++digit;
                    continue;
                }
                return;
            }
            if (digit == 0) {
                return;
            }
            if (dot ? digit > 3 : digit != 3) {
                this.registerErrorAtOffset((PsiElement)expression2, length - digit, digit, new Object[0]);
            }
        }
    }
}

