/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "getDisplayName"));
        }
        return string;
    }

    @org.intellij.lang.annotations.Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("StringConcatenationInLoop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "getID"));
        }
        return "StringConcatenationInLoop";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    static PsiLoopStatement getOutermostCommonLoop(PsiExpression expression2, PsiVariable variable) {
        PsiElement stopAt = null;
        PsiCodeBlock block = StringConcatenationInLoopsVisitor.getSurroundingBlock((PsiElement)expression2);
        if (block != null) {
            PsiExpression ref;
            if (expression2 instanceof PsiAssignmentExpression) {
                ref = expression2;
            } else {
                PsiReference reference = (PsiReference)ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)expression2)).findFirst();
                PsiElement psiElement = ref = reference != null ? reference.getElement() : null;
            }
            if (ref != null) {
                PsiElement[] elements = (PsiElement[])StreamEx.of((Object[])DefUseUtil.getDefs(block, variable, (PsiElement)expression2)).prepend((Object)expression2).toArray(PsiElement[]::new);
                stopAt = PsiTreeUtil.findCommonParent((PsiElement[])elements);
            }
        }
        PsiLoopStatement commonLoop = null;
        for (PsiElement parent = expression2.getParent(); !(parent == null || parent == stopAt || parent instanceof PsiMethod || parent instanceof PsiClass || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            if (!(parent instanceof PsiLoopStatement)) continue;
            commonLoop = (PsiLoopStatement)parent;
        }
        return commonLoop;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getAppendedVariable(PsiExpression expression2) {
        PsiExpression parent = expression2;
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)lhs).resolve();
        return element instanceof PsiVariable ? (PsiVariable)element : null;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])infos), PsiExpression.class);
        PsiVariable var = StringConcatenationInLoopsInspection.getAppendedVariable(expression2);
        if (var == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "buildFixes"));
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        ArrayList<AbstractStringBuilderFix> fixes = new ArrayList<AbstractStringBuilderFix>();
        if (var instanceof PsiLocalVariable) {
            fixes.add(new ReplaceWithStringBuilderFix(var));
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression2, var);
            if (ReferencesSearch.search((PsiElement)var).findAll().stream().map(PsiReference::getElement).filter(e -> !PsiTreeUtil.isAncestor((PsiElement)loop, (PsiElement)e, (boolean)true)).limit(2L).count() > 1L) {
                fixes.add(new IntroduceStringBuilderFix(var));
            }
        } else if (var instanceof PsiParameter) {
            fixes.add(new IntroduceStringBuilderFix(var));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    static class ReplaceWithStringBuilderFix
    extends AbstractStringBuilderFix {
        public ReplaceWithStringBuilderFix(PsiVariable variable) {
            super(variable);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiStatement commentPlace;
            PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiVariable variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression2);
            if (!(variable instanceof PsiLocalVariable)) {
                return;
            }
            variable.normalizeDeclaration();
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable, variable, null, ct);
            ct.replace((PsiElement)typeElement, this.myTargetType);
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ct.replace((PsiElement)initializer, this.generateNewStringBuilder(initializer, ct));
            }
            ct.insertCommentsBefore((PsiElement)((commentPlace = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class)) == null ? variable : commentPlace));
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix.name", this.myName, StringUtil.getShortName((String)this.myTargetType));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix", "getFamilyName"));
            }
            return string;
        }
    }

    static class IntroduceStringBuilderFix
    extends AbstractStringBuilderFix {
        public IntroduceStringBuilderFix(PsiVariable variable) {
            super(variable);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiVariable variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression2);
            if (variable == null) {
                return;
            }
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression2, variable);
            if (loop == null) {
                return;
            }
            ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(variable, loop);
            String newName = JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(variable.getName() + "Builder", (PsiElement)loop, true);
            String newStringBuilder = this.myTargetType + " " + newName + "=new " + this.myTargetType + "(" + variable.getName() + ");";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)loop, (Object)marker);
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)BlockUtils.addBefore((PsiStatement)loop, factory.createStatementFromText(newStringBuilder, (PsiElement)loop));
            if (!loop.isValid() && (loop = (PsiLoopStatement)PsiTreeUtil.releaseMark((PsiElement)declaration2.getParent(), (Object)marker)) == null) {
                return;
            }
            PsiVariable builderVariable = (PsiVariable)declaration2.getDeclaredElements()[0];
            PsiExpression builderInitializer = Objects.requireNonNull(builderVariable.getInitializer());
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable, builderVariable, (PsiElement)loop, ct);
            String toString = variable.getName() + " = " + newName + ".toString();";
            PsiExpression initializer = variable.getInitializer();
            switch (status) {
                case DECLARED_JUST_BEFORE: {
                    PsiTypeElement typeElement = variable.getTypeElement();
                    if (typeElement == null || initializer == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer, ct));
                    ct.replace((PsiElement)initializer, newName + ".toString()");
                    toString = variable.getText();
                    ct.delete((PsiElement)variable);
                    break;
                }
                case AT_WANTED_PLACE_ONLY: {
                    if (initializer == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer, ct));
                    initializer.delete();
                    break;
                }
                case AT_WANTED_PLACE: {
                    if (!ExpressionUtils.isSimpleExpression(initializer)) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer, ct));
                    break;
                }
                case UNKNOWN: {
                    PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)declaration2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                    PsiExpression prevAssignment = ExpressionUtils.getAssignmentTo(prevStatement, variable);
                    if (prevAssignment == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(prevAssignment, ct));
                    ct.delete(prevStatement);
                }
            }
            BlockUtils.addAfter((PsiStatement)loop, factory.createStatementFromText(toString, (PsiElement)loop));
            ct.insertCommentsBefore((PsiElement)loop);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix.name", this.myName, StringUtil.getShortName((String)this.myTargetType));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$IntroduceStringBuilderFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$IntroduceStringBuilderFix", "getFamilyName"));
            }
            return string;
        }
    }

    static abstract class AbstractStringBuilderFix
    extends InspectionGadgetsFix {
        static final Pattern PRINT_OR_PRINTLN = Pattern.compile("print|println");
        String myName;
        String myTargetType;

        public AbstractStringBuilderFix(PsiVariable variable) {
            this.myName = variable.getName();
            this.myTargetType = PsiUtil.isLanguageLevel5OrHigher((PsiElement)variable) ? "java.lang.StringBuilder" : "java.lang.StringBuffer";
        }

        @NotNull
        String generateNewStringBuilder(PsiExpression initializer, CommentTracker ct) {
            if (ExpressionUtils.isNullLiteral(initializer)) {
                String string = ct.text((PsiElement)initializer);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$AbstractStringBuilderFix", "generateNewStringBuilder"));
                }
                return string;
            }
            String text2 = initializer == null || ExpressionUtils.isLiteral((PsiElement)initializer, "") ? "" : ct.text((PsiElement)initializer);
            String string = "new " + this.myTargetType + "(" + text2 + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$AbstractStringBuilderFix", "generateNewStringBuilder"));
            }
            return string;
        }

        void replaceAll(PsiVariable variable, PsiVariable builderVariable, PsiElement scope, CommentTracker ct) {
            Query query = scope == null ? ReferencesSearch.search((PsiElement)variable) : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope));
            Collection refs = query.findAll();
            for (PsiReference ref : refs) {
                PsiElement target2 = ref.getElement();
                if (!(target2 instanceof PsiReferenceExpression) || !target2.isValid()) continue;
                this.replace(variable, builderVariable, (PsiReferenceExpression)target2, ct);
            }
        }

        private void replace(PsiVariable variable, PsiVariable builderVariable, PsiReferenceExpression ref, CommentTracker ct) {
            PsiBinaryExpression binOp;
            PsiMethodCallExpression call;
            PsiExpression[] expressions2;
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()) == ref) {
                    this.replaceInAssignment(variable, builderVariable, assignment, ct);
                    return;
                }
                if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                    return;
                }
            }
            if (variable != builderVariable) {
                ExpressionUtils.bindReferenceTo(ref, Objects.requireNonNull(builderVariable.getName()));
            }
            if ((methodCallExpression = ExpressionUtils.getCallForQualifier((PsiExpression)ref)) != null) {
                AbstractStringBuilderFix.replaceInCallQualifier(builderVariable, methodCallExpression, ct);
                return;
            }
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression && (expressions2 = ((PsiExpressionList)parent).getExpressions()).length == 1 && expressions2[0] == ref && AbstractStringBuilderFix.canAcceptBuilderInsteadOfString(call = (PsiMethodCallExpression)parent.getParent())) {
                return;
            }
            if (parent instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull(binOp = (PsiBinaryExpression)parent) != null) {
                return;
            }
            if (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression[] operands2;
                for (PsiExpression operand2 : operands2 = ((PsiPolyadicExpression)parent).getOperands()) {
                    if (operand2 == ref) break;
                    if (!TypeUtils.isJavaLangString(operand2.getType())) continue;
                    return;
                }
                if (operands2.length > 1 && operands2[0] == ref && TypeUtils.isJavaLangString(operands2[1].getType())) {
                    return;
                }
            }
            ct.replace((PsiElement)ref, builderVariable.getName() + ".toString()");
        }

        private static boolean canAcceptBuilderInsteadOfString(PsiMethodCallExpression call) {
            return MethodCallUtils.isCallToMethod(call, "java.lang.StringBuilder", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.lang.StringBuffer", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintStream", null, PRINT_OR_PRINTLN, (PsiType[])null) || MethodCallUtils.isCallToMethod(call, "java.io.PrintWriter", null, PRINT_OR_PRINTLN, (PsiType[])null);
        }

        private static void replaceInCallQualifier(PsiVariable variable, PsiMethodCallExpression call, CommentTracker ct) {
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                String name2;
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name2 = method.getName()) {
                    case "length": 
                    case "chars": 
                    case "codePoints": 
                    case "charAt": 
                    case "codePointAt": 
                    case "codePointBefore": 
                    case "codePointAfter": 
                    case "codePointCount": 
                    case "offsetByCodePoints": 
                    case "substring": 
                    case "subSequence": {
                        return;
                    }
                    case "getChars": {
                        if (args.length != 4) break;
                        return;
                    }
                    case "indexOf": 
                    case "lastIndexOf": {
                        if (args.length < 1 || args.length > 2 || !TypeUtils.isJavaLangString(args[0].getType())) break;
                        return;
                    }
                    case "isEmpty": {
                        String sign = "==";
                        PsiExpression negation = BoolUtils.findNegation((PsiExpression)call);
                        PsiMethodCallExpression toReplace = call;
                        if (negation != null) {
                            sign = ">";
                            toReplace = negation;
                        }
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
                        PsiExpression emptyCheck = factory.createExpressionFromText(variable.getName() + ".length()" + sign + "0", (PsiElement)call);
                        PsiElement callParent = toReplace.getParent();
                        if (callParent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(emptyCheck, (PsiExpression)callParent, true)) {
                            emptyCheck = factory.createExpressionFromText("(" + emptyCheck.getText() + ")", (PsiElement)call);
                        }
                        ct.replace((PsiElement)toReplace, (PsiElement)emptyCheck);
                        return;
                    }
                }
            }
            PsiExpression qualifier = Objects.requireNonNull(call.getMethodExpression().getQualifierExpression());
            ct.replace((PsiElement)qualifier, variable.getName() + ".toString()");
        }

        private void replaceInAssignment(PsiVariable variable, PsiVariable builderVariable, PsiAssignmentExpression assignment, CommentTracker ct) {
            PsiPolyadicExpression concat2;
            PsiExpression[] operands2;
            PsiExpression rValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ) && rValue instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)rValue).getOperationTokenType().equals(JavaTokenType.PLUS) && (operands2 = (concat2 = (PsiPolyadicExpression)rValue).getOperands()).length > 1) {
                if (ExpressionUtils.isReferenceTo(operands2[0], variable)) {
                    StreamEx.iterate((Object)operands2[1], Objects::nonNull, PsiElement::getNextSibling).forEach(ct::markUnchanged);
                    String text2 = rValue.getText().substring(operands2[1].getStartOffsetInParent());
                    PsiExpression added = JavaPsiFacade.getElementFactory((Project)variable.getProject()).createExpressionFromText(text2, (PsiElement)assignment);
                    this.replaceAll(variable, builderVariable, (PsiElement)added, ct);
                    StringBuilder replacement = ChangeToAppendUtil.buildAppendExpression(added, false, new StringBuilder(builderVariable.getName()));
                    if (replacement != null) {
                        ct.replace((PsiElement)assignment, replacement.toString());
                    }
                    return;
                }
                PsiExpression lastOp = operands2[operands2.length - 1];
                if (ExpressionUtils.isReferenceTo(lastOp, variable)) {
                    ct.delete(new PsiElement[]{concat2.getTokenBeforeOperand(lastOp), lastOp});
                    this.replaceAll(variable, builderVariable, (PsiElement)rValue, ct);
                    ct.replace((PsiElement)assignment, builderVariable.getName() + ".insert(0," + ct.text((PsiElement)rValue) + ")");
                    return;
                }
            }
            if (rValue != null) {
                this.replaceAll(variable, builderVariable, (PsiElement)rValue, ct);
                rValue = assignment.getRExpression();
            }
            if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                StringBuilder sb;
                String replacement = "";
                if (rValue != null && (sb = ChangeToAppendUtil.buildAppendExpression(ct.markUnchanged(rValue), false, new StringBuilder(builderVariable.getName()))) != null) {
                    replacement = sb.toString();
                }
                ct.replace((PsiElement)assignment, replacement);
            } else if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                ct.replace((PsiElement)assignment, builderVariable.getName() + "=" + this.generateNewStringBuilder(rValue, ct));
            }
        }
    }

    private static class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length <= 1) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression((PsiExpression)expression2)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)expression2)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.isAppendedRepeatedly((PsiExpression)expression2)) {
                return;
            }
            PsiJavaToken sign = expression2.getTokenBeforeOperand(operands2[1]);
            assert (sign != null);
            this.registerError((PsiElement)sign, expression2);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression2);
            if (expression2.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression2.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)sign, expression2);
        }

        private static boolean checkExpression(PsiExpression expression2) {
            PsiVariable variable;
            if (!TypeUtils.isJavaLangString(expression2.getType()) || ControlFlowUtils.isInExitStatement(expression2) || !ControlFlowUtils.isInLoop((PsiElement)expression2)) {
                return false;
            }
            PsiExpression parent = expression2;
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (parent != expression2 && parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                return false;
            }
            if (parent instanceof PsiAssignmentExpression && (variable = StringConcatenationInLoopsInspection.getAppendedVariable(expression2 = parent)) != null) {
                PsiLoopStatement commonLoop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression2, variable);
                return commonLoop != null && !ControlFlowUtils.isExecutedOnceInLoop((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class), commonLoop) && !StringConcatenationInLoopsVisitor.isUsedCompletely(variable, commonLoop);
            }
            return false;
        }

        private static boolean isUsedCompletely(PsiVariable variable, PsiLoopStatement loop) {
            boolean notUsedCompletely = ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)loop)).forEach(ref -> {
                PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)ref.getElement(), PsiExpression.class);
                if (expression2 == null) {
                    return true;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                while (parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression) {
                    parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                }
                if (parent instanceof PsiExpressionList || parent instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((PsiAssignmentExpression)parent).getRExpression(), (PsiElement)expression2, (boolean)false)) {
                    PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class);
                    return ControlFlowUtils.isExecutedOnceInLoop(statement2, loop) || ControlFlowUtils.isVariableReassigned(statement2, variable);
                }
                return true;
            });
            return !notUsedCompletely;
        }

        @Nullable
        private static PsiCodeBlock getSurroundingBlock(PsiElement expression2) {
            PsiElement body2;
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class});
            if (parent instanceof PsiMethod) {
                return ((PsiMethod)parent).getBody();
            }
            if (parent instanceof PsiClassInitializer) {
                return ((PsiClassInitializer)parent).getBody();
            }
            if (parent instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)parent).getBody()) instanceof PsiCodeBlock) {
                return (PsiCodeBlock)body2;
            }
            return null;
        }

        private static boolean isAppendedRepeatedly(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            return StringConcatenationInLoopsVisitor.isAppended(referenceExpression, rhs);
        }

        private static boolean isAppended(PsiReferenceExpression otherRef, PsiExpression expression2) {
            PsiPolyadicExpression polyadicExpression;
            if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiPolyadicExpression && (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                    if (!StringConcatenationInLoopsVisitor.isSameReference(operand2, otherRef) && !StringConcatenationInLoopsVisitor.isAppended(otherRef, operand2)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSameReference(PsiExpression operand2, PsiReferenceExpression ref) {
            PsiReferenceExpression other = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2), PsiReferenceExpression.class);
            if (other == null) {
                return false;
            }
            String name2 = other.getReferenceName();
            if (name2 == null || !name2.equals(ref.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = ref.getQualifierExpression();
            PsiExpression otherQualifier = other.getQualifierExpression();
            if (qualifier == null && otherQualifier == null) {
                return true;
            }
            if (qualifier == null && ref.resolve() instanceof PsiField) {
                qualifier = ExpressionUtils.getQualifierOrThis(ref);
            }
            if (otherQualifier == null && other.resolve() instanceof PsiField) {
                otherQualifier = ExpressionUtils.getQualifierOrThis(other);
            }
            if (qualifier == null || otherQualifier == null) {
                return false;
            }
            if (qualifier instanceof PsiReferenceExpression) {
                return StringConcatenationInLoopsVisitor.isSameReference(otherQualifier, (PsiReferenceExpression)qualifier);
            }
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)otherQualifier);
        }
    }
}

