/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;

public class BlockUtils {
    public static PsiStatement addBefore(PsiStatement anchor, PsiStatement ... newStatements) {
        if (newStatements.length == 0) {
            throw new IllegalArgumentException();
        }
        PsiStatement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = parent;
            parent = oldStatement.getParent();
        }
        if (newStatements.length == 1 && oldStatement instanceof PsiEmptyStatement) {
            return (PsiStatement)oldStatement.replace((PsiElement)newStatements[0]);
        }
        PsiElement result2 = null;
        if (parent instanceof PsiCodeBlock) {
            for (PsiStatement statement2 : newStatements) {
                result2 = parent.addBefore((PsiElement)statement2, (PsiElement)oldStatement);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)oldStatement);
            PsiCodeBlock codeBlock = newBlockStatement.getCodeBlock();
            for (PsiStatement newStatement : newStatements) {
                codeBlock.add((PsiElement)newStatement);
            }
            codeBlock.add((PsiElement)oldStatement);
            PsiStatement[] statements = ((PsiBlockStatement)oldStatement.replace((PsiElement)newBlockStatement)).getCodeBlock().getStatements();
            result2 = statements[statements.length - 2];
        }
        return (PsiStatement)result2;
    }

    public static PsiStatement addAfter(PsiStatement anchor, PsiStatement newStatement) {
        PsiElement result2;
        PsiStatement oldStatement = anchor;
        PsiElement parent = oldStatement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            oldStatement = parent;
            parent = oldStatement.getParent();
        }
        if (parent instanceof PsiCodeBlock) {
            result2 = parent.addAfter((PsiElement)newStatement, (PsiElement)oldStatement);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)oldStatement);
            PsiCodeBlock codeBlock = newBlockStatement.getCodeBlock();
            codeBlock.add((PsiElement)oldStatement);
            codeBlock.add((PsiElement)newStatement);
            result2 = ((PsiBlockStatement)oldStatement.replace((PsiElement)newBlockStatement)).getCodeBlock().getStatements()[1];
        }
        return (PsiStatement)result2;
    }
}

