/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtils {
    private static final Set<String> immutableTypes = new HashSet<String>(19);
    private static final Set<PsiType> primitiveNumericTypes = new HashSet<PsiType>(7);
    private static final Set<PsiType> integralTypes = new HashSet<PsiType>(5);

    private ClassUtils() {
    }

    @Nullable
    public static PsiClass findClass(@NonNls String fqClassName, PsiElement context) {
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqClassName, context.getResolveScope());
    }

    @Nullable
    public static PsiClass findObjectClass(PsiElement context) {
        return ClassUtils.findClass("java.lang.Object", context);
    }

    public static boolean isPrimitive(PsiType type2) {
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2);
    }

    public static boolean isIntegral(PsiType type2) {
        return integralTypes.contains(type2);
    }

    public static boolean isImmutable(PsiType type2) {
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2)) {
            return true;
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        if (immutableTypes.contains(aClass.getQualifiedName())) {
            return true;
        }
        return JCiPUtil.isImmutable(aClass);
    }

    public static boolean inSamePackage(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null || element2 == null) {
            return false;
        }
        PsiFile containingFile1 = element1.getContainingFile();
        if (!(containingFile1 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile1 = (PsiClassOwner)containingFile1;
        String packageName1 = containingJavaFile1.getPackageName();
        PsiFile containingFile2 = element2.getContainingFile();
        if (!(containingFile2 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile2 = (PsiClassOwner)containingFile2;
        String packageName2 = containingJavaFile2.getPackageName();
        return packageName1.equals(packageName2);
    }

    public static boolean isFieldVisible(@NotNull PsiField field, PsiClass fromClass) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/psiutils/ClassUtils", "isFieldVisible"));
        }
        PsiClass fieldClass = field.getContainingClass();
        if (fieldClass == null) {
            return false;
        }
        if (fieldClass.equals(fromClass)) {
            return true;
        }
        if (field.hasModifierProperty("private")) {
            return false;
        }
        if (field.hasModifierProperty("public") || field.hasModifierProperty("protected")) {
            return true;
        }
        return ClassUtils.inSamePackage((PsiElement)fieldClass, (PsiElement)fromClass);
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveNumericType(@Nullable PsiType type2) {
        return primitiveNumericTypes.contains(type2);
    }

    public static boolean isInnerClass(PsiClass aClass) {
        PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)aClass);
        return parentClass != null;
    }

    @Nullable
    public static PsiClass getContainingClass(PsiElement element) {
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    public static PsiClass getOutermostContainingClass(PsiClass aClass) {
        PsiClass containingClass;
        PsiClass outerClass = aClass;
        while ((containingClass = ClassUtils.getContainingClass((PsiElement)outerClass)) != null) {
            outerClass = containingClass;
        }
        return outerClass;
    }

    @Nullable
    public static PsiClass getContainingStaticClass(PsiElement element) {
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiFile.class});
        while (ClassUtils.isNonStaticClass(aClass)) {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true, (Class[])new Class[]{PsiFile.class});
        }
        return aClass;
    }

    public static boolean isNonStaticClass(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiElement parent = aClass.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return false;
        }
        if (!(parent instanceof PsiClass)) {
            return true;
        }
        PsiClass parentClass = (PsiClass)parent;
        return !parentClass.isInterface();
    }

    @Nullable
    public static PsiClassInitializer getDoubleBraceInitializer(PsiAnonymousClass aClass) {
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (initializers.length != 1) {
            return null;
        }
        PsiClassInitializer initializer = initializers[0];
        if (initializer.hasModifierProperty("static")) {
            return null;
        }
        PsiField[] fields = aClass.getFields();
        if (fields.length != 0) {
            return null;
        }
        PsiMethod[] methods = aClass.getMethods();
        if (methods.length != 0) {
            return null;
        }
        PsiClass[] innerClasses = aClass.getInnerClasses();
        if (innerClasses.length != 0) {
            return null;
        }
        PsiJavaCodeReferenceElement reference = aClass.getBaseClassReference();
        if (reference.resolve() == null) {
            return null;
        }
        return initializer;
    }

    static {
        integralTypes.add((PsiType)PsiType.LONG);
        integralTypes.add((PsiType)PsiType.INT);
        integralTypes.add((PsiType)PsiType.SHORT);
        integralTypes.add((PsiType)PsiType.CHAR);
        integralTypes.add((PsiType)PsiType.BYTE);
        primitiveNumericTypes.add((PsiType)PsiType.BYTE);
        primitiveNumericTypes.add((PsiType)PsiType.CHAR);
        primitiveNumericTypes.add((PsiType)PsiType.SHORT);
        primitiveNumericTypes.add((PsiType)PsiType.INT);
        primitiveNumericTypes.add((PsiType)PsiType.LONG);
        primitiveNumericTypes.add((PsiType)PsiType.FLOAT);
        primitiveNumericTypes.add((PsiType)PsiType.DOUBLE);
        immutableTypes.add("java.lang.Boolean");
        immutableTypes.add("java.lang.Character");
        immutableTypes.add("java.lang.Short");
        immutableTypes.add("java.lang.Integer");
        immutableTypes.add("java.lang.Long");
        immutableTypes.add("java.lang.Float");
        immutableTypes.add("java.lang.Double");
        immutableTypes.add("java.lang.Byte");
        immutableTypes.add("java.lang.String");
        immutableTypes.add("java.awt.Font");
        immutableTypes.add("java.awt.BasicStroke");
        immutableTypes.add("java.awt.Color");
        immutableTypes.add("java.awt.Cursor");
        immutableTypes.add("java.math.BigDecimal");
        immutableTypes.add("java.math.BigInteger");
        immutableTypes.add("java.math.MathContext");
        immutableTypes.add("java.nio.channels.FileLock");
        immutableTypes.add("java.nio.charset.Charset");
        immutableTypes.add("java.io.File");
        immutableTypes.add("java.net.Inet4Address");
        immutableTypes.add("java.net.Inet6Address");
        immutableTypes.add("java.net.InetSocketAddress");
        immutableTypes.add("java.net.URI");
        immutableTypes.add("java.net.URL");
        immutableTypes.add("java.util.Locale");
        immutableTypes.add("java.util.UUID");
        immutableTypes.add("java.util.regex.Pattern");
    }
}

