/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StatementExtractor {
    private static final Node EMPTY = new Node(null){

        @Override
        public Node prepend(Node node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    @NotNull
    public static PsiStatement[] generateStatements(List<PsiExpression> expressionsToKeep, PsiExpression root) {
        String statementsCode = StatementExtractor.generateStatementsText(expressionsToKeep, root);
        if (statementsCode.isEmpty()) {
            if (PsiStatement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "generateStatements"));
            }
            return PsiStatement.EMPTY_ARRAY;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)root.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{" + statementsCode + "}", (PsiElement)root);
        PsiStatement[] psiStatementArray = codeBlock.getStatements();
        if (psiStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "generateStatements"));
        }
        return psiStatementArray;
    }

    public static String generateStatementsText(List<PsiExpression> expressionsToKeep, PsiExpression root) {
        Node result2 = (Node)StreamEx.ofReversed(expressionsToKeep).map(expression2 -> StatementExtractor.createNode(expression2, root)).foldLeft((Object)EMPTY, Node::prepend);
        return result2.toString();
    }

    @NotNull
    private static Node createNode(@NotNull PsiExpression expression2, @NotNull PsiExpression root) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor", "createNode"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/siyeh/ig/psiutils/StatementExtractor", "createNode"));
        }
        Node result2 = new Expr(expression2);
        while (expression2 != root) {
            PsiExpression parent;
            PsiElement parentElement = expression2.getParent();
            if (parentElement instanceof PsiExpressionList) {
                parentElement = parentElement.getParent();
            }
            if ((parent = (PsiExpression)ObjectUtils.tryCast((Object)parentElement, PsiExpression.class)) == null) {
                throw new RuntimeExceptionWithAttachments("Expected to have expression parent", new Attachment[]{new Attachment("expression.txt", expression2.getText()), new Attachment("root.txt", root.getText())});
            }
            result2 = StatementExtractor.foldNode(result2, expression2, parent);
            expression2 = parent;
        }
        Expr expr = result2;
        if (expr == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "createNode"));
        }
        return expr;
    }

    @NotNull
    private static Node foldNode(@NotNull Node node, @NotNull PsiExpression expression2, @NotNull PsiExpression parent) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
        }
        if (parent instanceof PsiPolyadicExpression) {
            boolean and;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType type2 = polyadic.getOperationTokenType();
            if (type2 == JavaTokenType.ANDAND) {
                and = true;
            } else if (type2 == JavaTokenType.OROR) {
                and = false;
            } else {
                Node node2 = node;
                if (node2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
                }
                return node2;
            }
            Object[] operands2 = polyadic.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands2, (Object)expression2);
            if (index == 0) {
                Node node3 = node;
                if (node3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
                }
                return node3;
            }
            Cond cond = new Cond(parent, parent, index, and ? node : EMPTY, and ? EMPTY : node);
            if (cond == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
            }
            return cond;
        }
        if (parent instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
            if (expression2 == ternary.getThenExpression()) {
                Cond cond = new Cond((PsiExpression)ternary, ternary.getCondition(), -1, node, EMPTY);
                if (cond == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
                }
                return cond;
            }
            if (expression2 == ternary.getElseExpression()) {
                Cond cond = new Cond((PsiExpression)ternary, ternary.getCondition(), -1, EMPTY, node);
                if (cond == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
                }
                return cond;
            }
        }
        Node node4 = node;
        if (node4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "foldNode"));
        }
        return node4;
    }

    private static class Cons
    extends Node {
        @NotNull
        private final Node myHead;
        @NotNull
        private final Node myTail;

        private Cons(@NotNull Node head, @NotNull Node tail) {
            if (head == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "com/siyeh/ig/psiutils/StatementExtractor$Cons", "<init>"));
            }
            if (tail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/siyeh/ig/psiutils/StatementExtractor$Cons", "<init>"));
            }
            super(head.myAnchor);
            assert (!(head instanceof Cons));
            this.myHead = head;
            this.myTail = tail;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myHead.myAnchor, (PsiElement)node.myAnchor, (boolean)false)) {
                Node newHead = this.myHead.prepend(node);
                return new Cons(newHead, this.myTail);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myHead.toString() + this.myTail;
        }
    }

    private static class Expr
    extends Node {
        private Expr(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor$Expr", "<init>"));
            }
            super(expression2);
        }

        @Override
        public Node prepend(Node node) {
            return node.myAnchor == null ? this : new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myAnchor.getText() + ";";
        }
    }

    private static class Cond
    extends Node {
        @NotNull
        private final PsiExpression myCondition;
        @NotNull
        private final Node myThenBranch;
        @NotNull
        private final Node myElseBranch;
        private final int myLimit;

        private Cond(@NotNull PsiExpression anchor, @NotNull PsiExpression condition2, int limit, @NotNull Node thenBranch, @NotNull Node elseBranch) {
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            if (condition2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            if (thenBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            if (elseBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseBranch", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            super(anchor);
            this.myCondition = condition2;
            this.myLimit = limit;
            assert (limit < 0 || condition2 instanceof PsiPolyadicExpression);
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
        }

        private String getCondition(boolean invert) {
            if (this.myLimit < 0) {
                return invert ? BoolUtils.getNegatedExpressionText(this.myCondition) : this.myCondition.getText();
            }
            PsiPolyadicExpression condition2 = (PsiPolyadicExpression)this.myCondition;
            Object[] operands2 = condition2.getOperands();
            String joiner = condition2.getOperationTokenType() == JavaTokenType.ANDAND != invert ? "&&" : "||";
            return StreamEx.of((Object[])operands2, (int)0, (int)this.myLimit).map(invert ? BoolUtils::getNegatedExpressionText : PsiElement::getText).joining((CharSequence)joiner);
        }

        @Override
        public String toString() {
            if (this.myThenBranch == EMPTY) {
                return "if(" + this.getCondition(true) + ") {" + this.myElseBranch + "}";
            }
            return "if(" + this.getCondition(false) + ") {" + this.myThenBranch + "}" + (this.myElseBranch == EMPTY ? "" : "else {" + this.myElseBranch + "}");
        }

        @Override
        public Node prepend(Node node) {
            PsiExpression thatAnchor = node.myAnchor;
            if (thatAnchor == null) {
                return this;
            }
            if (thatAnchor == this.myAnchor) {
                assert (node instanceof Cond);
                Cond cond = (Cond)node;
                assert (this.myCondition == cond.myCondition);
                if (this.myLimit == cond.myLimit) {
                    return new Cond(this.myAnchor, this.myCondition, this.myLimit, this.myThenBranch.prepend(cond.myThenBranch), this.myElseBranch.prepend(cond.myElseBranch));
                }
                assert (this.myLimit > cond.myLimit);
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myCondition, (PsiElement)thatAnchor, (boolean)false)) {
                return this;
            }
            return new Cons(node, this);
        }
    }

    private static abstract class Node {
        final PsiExpression myAnchor;

        protected Node(PsiExpression anchor) {
            this.myAnchor = anchor;
        }

        public abstract Node prepend(Node var1);

        public abstract String toString();
    }
}

