/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiUtil {
    @Contract(value="null -> null")
    public static PsiType getStreamElementType(PsiType type2) {
        return StreamApiUtil.getStreamElementType(type2, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getStreamElementType(PsiType type2, boolean variableType) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.IntStream")) {
            return PsiType.INT;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.LongStream")) {
            return PsiType.LONG;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.DoubleStream")) {
            return PsiType.DOUBLE;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.Stream")) {
            return null;
        }
        PsiType streamType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.stream.Stream", (int)0, (boolean)false);
        if (variableType) {
            if (streamType instanceof PsiIntersectionType) {
                return null;
            }
            streamType = GenericsUtil.getVariableTypeByExpressionType((PsiType)streamType);
        }
        return streamType;
    }

    public static boolean isNullOrEmptyStream(PsiExpression expression2) {
        if (ExpressionUtils.isNullLiteral(expression2)) {
            return true;
        }
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        String name2 = call.getMethodExpression().getReferenceName();
        if (!"empty".equals(name2) && !"of".equals(name2) || call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || !method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.util.stream.");
    }

    @Contract(value="null -> false")
    public static boolean isSupportedStreamElement(PsiType type2) {
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.equals(PsiType.INT) || type2.equals(PsiType.LONG) || type2.equals(PsiType.DOUBLE);
        }
        return true;
    }

    @NotNull
    public static String generateMapOperation(PsiVariable variable, @Nullable PsiType outType, PsiElement mapper) {
        String shortcutMappingMethod = StreamApiUtil.getShortcutMappingMethod(variable, outType, mapper);
        if (shortcutMappingMethod != null) {
            String string = shortcutMappingMethod.isEmpty() ? "" : "." + shortcutMappingMethod + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
            }
            return string;
        }
        PsiType inType = variable.getType();
        String operationName = StreamApiUtil.getMapOperationName(inType, outType);
        if (outType != null && mapper instanceof PsiArrayInitializerExpression) {
            mapper = RefactoringUtil.convertInitializerToNormalExpression((PsiExpression)mapper, outType);
        }
        String typeArgument = mapper instanceof PsiExpression ? OptionalUtil.getMapTypeArgument((PsiExpression)mapper, outType) : "";
        String string = "." + typeArgument + operationName + "(" + variable.getName() + "->" + mapper.getText() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "generateMapOperation"));
        }
        return string;
    }

    @Nullable
    public static String getShortcutMappingMethod(PsiVariable variable, @Nullable PsiType outType, PsiElement mapper) {
        if (!(mapper instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)mapper));
        PsiType inType = variable.getType();
        if (expression2 instanceof PsiTypeCastExpression && inType instanceof PsiPrimitiveType && Objects.equals(expression2.getType(), outType)) {
            expression2 = ((PsiTypeCastExpression)expression2).getOperand();
        }
        if (ExpressionUtils.isReferenceTo(expression2, variable)) {
            if (!(outType instanceof PsiPrimitiveType)) {
                return inType instanceof PsiPrimitiveType ? "boxed" : "";
            }
            if (outType.equals(inType)) {
                return "";
            }
            if (PsiType.LONG.equals((Object)outType) && PsiType.INT.equals((Object)inType)) {
                return "asLongStream";
            }
            if (PsiType.DOUBLE.equals((Object)outType) && (PsiType.LONG.equals((Object)inType) || PsiType.INT.equals((Object)inType))) {
                return "asDoubleStream";
            }
        }
        return null;
    }

    @NotNull
    public static String getMapOperationName(PsiType inType, @Nullable PsiType outType) {
        if (outType instanceof PsiPrimitiveType) {
            if (!outType.equals(inType)) {
                if (PsiType.INT.equals((Object)outType)) {
                    if ("mapToInt" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "getMapOperationName"));
                    }
                    return "mapToInt";
                }
                if (PsiType.LONG.equals((Object)outType)) {
                    if ("mapToLong" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "getMapOperationName"));
                    }
                    return "mapToLong";
                }
                if (PsiType.DOUBLE.equals((Object)outType)) {
                    if ("mapToDouble" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "getMapOperationName"));
                    }
                    return "mapToDouble";
                }
            }
        } else if (inType instanceof PsiPrimitiveType) {
            if ("mapToObj" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "getMapOperationName"));
            }
            return "mapToObj";
        }
        if ("map" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StreamApiUtil", "getMapOperationName"));
        }
        return "map";
    }

    @Nullable
    public static String getFlatMapOperationName(PsiType inType, PsiType outType) {
        if (!(inType instanceof PsiPrimitiveType)) {
            if (PsiType.INT.equals((Object)outType)) {
                return "flatMapToInt";
            }
            if (PsiType.LONG.equals((Object)outType)) {
                return "flatMapToLong";
            }
            if (PsiType.DOUBLE.equals((Object)outType)) {
                return "flatMapToDouble";
            }
        } else if (!inType.equals(outType)) {
            return null;
        }
        return "flatMap";
    }
}

