/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UninitializedReadCollector {
    private final Set<PsiExpression> uninitializedReads = new HashSet<PsiExpression>();
    private int counter = 0;

    @NotNull
    public PsiExpression[] getUninitializedReads() {
        PsiExpression[] psiExpressionArray = this.uninitializedReads.toArray(new PsiExpression[this.uninitializedReads.size()]);
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/UninitializedReadCollector", "getUninitializedReads"));
        }
        return psiExpressionArray;
    }

    public boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "blockAssignsVariable"));
        }
        return this.blockAssignsVariable(block, variable, this.counter, new HashSet<MethodSignature>());
    }

    private boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement[] statements;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "blockAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "blockAssignsVariable"));
        }
        if (this.counter != stamp) {
            return true;
        }
        if (block == null) {
            return false;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (this.statementAssignsVariable(statement2, variable, stamp, checkedMethods)) {
                return true;
            }
            if (this.counter == stamp) continue;
            return true;
        }
        return false;
    }

    private boolean statementAssignsVariable(@Nullable PsiStatement statement2, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "statementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "statementAssignsVariable"));
        }
        if (statement2 == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement2)) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return this.expressionAssignsVariable(returnValue, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement2;
            PsiExpression exception = throwStatement.getException();
            return this.expressionAssignsVariable(exception, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions2;
            PsiExpressionListStatement list2 = (PsiExpressionListStatement)statement2;
            PsiExpressionList expressionList = list2.getExpressionList();
            for (PsiExpression expression2 : expressions2 = expressionList.getExpressions()) {
                if (!this.expressionAssignsVariable(expression2, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression3 = expressionStatement.getExpression();
            return this.expressionAssignsVariable(expression3, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            return this.declarationStatementAssignsVariable(declarationStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement2;
            return this.forStatementAssignsVariable(forStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement2;
            return this.foreachStatementAssignsVariable(foreachStatement, variable);
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            return this.whileStatementAssignsVariable(whileStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement2;
            return this.doWhileAssignsVariable(doWhileStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body2 = synchronizedStatement.getBody();
            return this.blockAssignsVariable(body2, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return this.blockAssignsVariable(codeBlock, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return this.statementAssignsVariable(statementLabeled, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            return this.ifStatementAssignsVariable(ifStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            return this.tryStatementAssignsVariable(tryStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement2;
            return this.switchStatementAssignsVariable(switchStatement, variable, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        assert (false) : "unknown statement: " + statement2;
        return false;
    }

    private boolean switchStatementAssignsVariable(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "switchStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "switchStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "switchStatementAssignsVariable"));
        }
        PsiExpression expression2 = switchStatement.getExpression();
        if (this.expressionAssignsVariable(expression2, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i2 = 0; i2 < statements.length; ++i2) {
            PsiStatement statement2 = statements[i2];
            if (statement2 instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement2;
                if (i2 == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement2 instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i2 != statements.length - 1 || (assigns |= this.statementAssignsVariable(statement2, variable, stamp, checkedMethods))) continue;
            return false;
        }
        return containsDefault;
    }

    private boolean declarationStatementAssignsVariable(@NotNull PsiDeclarationStatement declarationStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement[] elements;
        if (declarationStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "declarationStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "declarationStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "declarationStatementAssignsVariable"));
        }
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable variableElement;
            PsiExpression initializer;
            if (!(element instanceof PsiVariable) || !this.expressionAssignsVariable(initializer = (variableElement = (PsiVariable)element).getInitializer(), variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementAssignsVariable(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "tryStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "tryStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "tryStatementAssignsVariable"));
        }
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer;
                if (!(resource instanceof PsiResourceVariable) || !this.expressionAssignsVariable(initializer = ((PsiResourceVariable)resource).getInitializer(), variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        boolean initializedInTryOrCatch = this.blockAssignsVariable(tryBlock, variable, stamp, checkedMethods);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            initializedInTryOrCatch &= this.blockAssignsVariable(catchBlock, variable, stamp, checkedMethods);
        }
        if (initializedInTryOrCatch) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return this.blockAssignsVariable(finallyBlock, variable, stamp, checkedMethods);
    }

    private boolean ifStatementAssignsVariable(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "ifStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "ifStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "ifStatementAssignsVariable"));
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return this.statementAssignsVariable(thenBranch, variable, stamp, checkedMethods) && this.statementAssignsVariable(elseBranch, variable, stamp, checkedMethods);
    }

    private boolean doWhileAssignsVariable(@NotNull PsiDoWhileStatement doWhileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (doWhileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doWhileStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "doWhileAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "doWhileAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "doWhileAssignsVariable"));
        }
        PsiExpression condition2 = doWhileStatement.getCondition();
        PsiStatement body2 = doWhileStatement.getBody();
        return this.statementAssignsVariable(body2, variable, stamp, checkedMethods) || this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods);
    }

    private boolean whileStatementAssignsVariable(@NotNull PsiWhileStatement whileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement body2;
        if (whileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "whileStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "whileStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "whileStatementAssignsVariable"));
        }
        PsiExpression condition2 = whileStatement.getCondition();
        if (this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods)) {
            return true;
        }
        return BoolUtils.isTrue(condition2) && this.statementAssignsVariable(body2 = whileStatement.getBody(), variable, stamp, checkedMethods);
    }

    private boolean forStatementAssignsVariable(@NotNull PsiForStatement forStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/siyeh/ig/psiutils/UninitializedReadCollector", "forStatementAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "forStatementAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "forStatementAssignsVariable"));
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (this.statementAssignsVariable(initialization, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods)) {
            return true;
        }
        if (BoolUtils.isTrue(condition2)) {
            PsiStatement body2 = forStatement.getBody();
            if (this.statementAssignsVariable(body2, variable, stamp, checkedMethods)) {
                return true;
            }
            PsiStatement update2 = forStatement.getUpdate();
            if (this.statementAssignsVariable(update2, variable, stamp, checkedMethods)) {
                return true;
            }
        }
        return false;
    }

    private boolean foreachStatementAssignsVariable(PsiForeachStatement forStatement, PsiVariable variable) {
        return false;
    }

    private boolean expressionAssignsVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "expressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "expressionAssignsVariable"));
        }
        if (this.counter != stamp) {
            return true;
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiSuperExpression || expression2 instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            return this.referenceExpressionAssignsVariable(referenceExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression2;
            return this.methodCallAssignsVariable(callExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            return this.newExpressionAssignsVariable(newExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiExpression[] initializers;
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer : initializers = array.getInitializers()) {
                if (!this.expressionAssignsVariable(initializer, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression2;
            PsiExpression operand2 = typeCast.getOperand();
            return this.expressionAssignsVariable(operand2, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = accessExpression.getArrayExpression();
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            return this.expressionAssignsVariable(arrayExpression, variable, stamp, checkedMethods) || this.expressionAssignsVariable(indexExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            PsiExpression operand3 = prefixExpression.getOperand();
            return this.expressionAssignsVariable(operand3, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression2;
            PsiExpression operand4 = postfixExpression.getOperand();
            return this.expressionAssignsVariable(operand4, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands2;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand5 : operands2 = polyadicExpression.getOperands()) {
                if (!this.expressionAssignsVariable(operand5, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression condition2 = conditional.getCondition();
            if (this.expressionAssignsVariable(condition2, variable, stamp, checkedMethods)) {
                return true;
            }
            PsiExpression thenExpression2 = conditional.getThenExpression();
            PsiExpression elseExpression2 = conditional.getElseExpression();
            return this.expressionAssignsVariable(thenExpression2, variable, stamp, checkedMethods) && this.expressionAssignsVariable(elseExpression2, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            return this.assignmentExpressionAssignsVariable(assignment, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return this.expressionAssignsVariable(innerExpression, variable, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            PsiExpression operand6 = instanceOfExpression.getOperand();
            return this.expressionAssignsVariable(operand6, variable, stamp, checkedMethods);
        }
        return false;
    }

    private boolean assignmentExpressionAssignsVariable(@NotNull PsiAssignmentExpression assignment, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement element;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/UninitializedReadCollector", "assignmentExpressionAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "assignmentExpressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "assignmentExpressionAssignsVariable"));
        }
        PsiExpression lhs = ParenthesesUtils.stripParentheses(assignment.getLExpression());
        if (this.expressionAssignsVariable(lhs, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (this.expressionAssignsVariable(rhs, variable, stamp, checkedMethods)) {
            return true;
        }
        return lhs instanceof PsiReferenceExpression && (element = ((PsiReference)lhs).resolve()) != null && element.equals(variable);
    }

    private boolean referenceExpressionAssignsVariable(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/UninitializedReadCollector", "referenceExpressionAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "referenceExpressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "referenceExpressionAssignsVariable"));
        }
        PsiExpression qualifierExpression2 = referenceExpression.getQualifierExpression();
        if (this.expressionAssignsVariable(qualifierExpression2, variable, stamp, checkedMethods)) {
            return true;
        }
        if (variable.equals(referenceExpression.resolve())) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)referenceExpression);
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && rhs.equals(referenceExpression)) {
                    this.checkReferenceExpression(referenceExpression, variable, qualifierExpression2);
                }
            } else if (!(parent instanceof PsiExpression) || !ComparisonUtils.isNullComparison((PsiExpression)parent)) {
                this.checkReferenceExpression(referenceExpression, variable, qualifierExpression2);
            }
        }
        return false;
    }

    private void checkReferenceExpression(PsiReferenceExpression referenceExpression, PsiVariable variable, PsiExpression qualifierExpression2) {
        PsiReferenceExpression reference;
        PsiElement target2;
        if (!referenceExpression.isQualified() || qualifierExpression2 instanceof PsiThisExpression) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        } else if (variable.hasModifierProperty("static") && qualifierExpression2 instanceof PsiReferenceExpression && (target2 = (reference = (PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiClass && target2.equals(PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class))) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        }
    }

    private boolean newExpressionAssignsVariable(@NotNull PsiNewExpression newExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arrayDimensions;
        PsiArrayInitializerExpression arrayInitializer;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/psiutils/UninitializedReadCollector", "newExpressionAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "newExpressionAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "newExpressionAssignsVariable"));
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                if (!this.expressionAssignsVariable(arg, variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        if (this.expressionAssignsVariable((PsiExpression)(arrayInitializer = newExpression.getArrayInitializer()), variable, stamp, checkedMethods)) {
            return true;
        }
        for (PsiExpression dim : arrayDimensions = newExpression.getArrayDimensions()) {
            if (!this.expressionAssignsVariable(dim, variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean methodCallAssignsVariable(@NotNull PsiMethodCallExpression callExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arguments;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/siyeh/ig/psiutils/UninitializedReadCollector", "methodCallAssignsVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/UninitializedReadCollector", "methodCallAssignsVariable"));
        }
        if (checkedMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkedMethods", "com/siyeh/ig/psiutils/UninitializedReadCollector", "methodCallAssignsVariable"));
        }
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        if (this.expressionAssignsVariable((PsiExpression)methodExpression, variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpressionList argumentList = callExpression.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!this.expressionAssignsVariable(argument, variable, stamp, checkedMethods)) continue;
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("final") || calledClass.hasModifierProperty("final")) {
            PsiCodeBlock body2 = method.getBody();
            return this.blockAssignsVariable(body2, variable, stamp, checkedMethods);
        }
        return false;
    }
}

