/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableUsedInArrayInitializerVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    VariableUsedInArrayInitializerVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableUsedInArrayInitializerVisitor", "<init>"));
        }
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableUsedInArrayInitializerVisitor", "visitElement"));
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        if (this.passed) {
            return;
        }
        super.visitArrayInitializerExpression(expression2);
        for (PsiExpression initializer : initializers = expression2.getInitializers()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) continue;
            this.passed = true;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

