/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SerializableStoresNonSerializableInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.stores.non.serializable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiElement classOrLambda = (PsiElement)infos[0];
        PsiType type2 = (PsiType)infos[1];
        if (classOrLambda instanceof PsiClass) {
            PsiClass aClass = (PsiClass)classOrLambda;
            if (aClass instanceof PsiAnonymousClass) {
                String string = InspectionGadgetsBundle.message("serializable.anonymous.class.stores.non.serializable.problem.descriptor", type2.getPresentableText());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("serializable.local.class.stores.non.serializable.problem.descriptor", type2.getPresentableText(), aClass.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("serializable.lambda.stores.non.serializable.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableStoresNonSerializableVisitor();
    }

    private static class SerializableStoresNonSerializableVisitor
    extends BaseInspectionVisitor {
        private SerializableStoresNonSerializableVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiDeclarationStatement) && !(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            LocalVariableReferenceFinder visitor = new LocalVariableReferenceFinder((PsiElement)aClass);
            for (PsiElement child = aClass.getLBrace(); child != null; child = child.getNextSibling()) {
                child.accept((PsiElementVisitor)visitor);
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            PsiType type2 = lambda2.getFunctionalInterfaceType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            lambda2.accept((PsiElementVisitor)new LocalVariableReferenceFinder((PsiElement)lambda2));
        }

        private class LocalVariableReferenceFinder
        extends JavaRecursiveElementWalkingVisitor {
            @NotNull
            private final PsiElement myClassOrLambda;

            public LocalVariableReferenceFinder(PsiElement classOrLambda) {
                if (classOrLambda == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrLambda", "com/siyeh/ig/serialization/SerializableStoresNonSerializableInspection$SerializableStoresNonSerializableVisitor$LocalVariableReferenceFinder", "<init>"));
                }
                this.myClassOrLambda = classOrLambda;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiType type2 = expression2.getType();
                if (SerializationUtils.isProbablySerializable(type2)) {
                    return;
                }
                PsiElement target2 = expression2.resolve();
                if (!(target2 instanceof PsiLocalVariable) && !(target2 instanceof PsiParameter)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target2;
                if (!(variable.hasModifierProperty("final") || PsiUtil.isLanguageLevel8OrHigher((PsiElement)variable) && HighlightControlFlowUtil.isEffectivelyFinal(variable, this.myClassOrLambda, (PsiJavaCodeReferenceElement)expression2))) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)this.myClassOrLambda, (PsiElement)variable, (boolean)true)) {
                    return;
                }
                SerializableStoresNonSerializableVisitor.this.registerError((PsiElement)expression2, new Object[]{this.myClassOrLambda, type2});
            }
        }
    }
}

