/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class TypeParameterExtendsObjectInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.extends.object.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/TypeParameterExtendsObjectInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("TypeParameterExplicitlyExtendsObject" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/TypeParameterExtendsObjectInspection", "getID"));
        }
        return "TypeParameterExplicitlyExtendsObject";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer type2 = (Integer)infos[0];
        if (type2 == 1) {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor1", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/TypeParameterExtendsObjectInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor2", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/TypeParameterExtendsObjectInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtendsObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsObjectVisitor();
    }

    private static class ExtendsObjectVisitor
    extends BaseInspectionVisitor {
        private ExtendsObjectVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length != 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            if (!extendsType.equalsToText("java.lang.Object")) {
                return;
            }
            PsiIdentifier nameIdentifier = parameter.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerError((PsiElement)nameIdentifier, 1);
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiElement lastChild = typeElement.getLastChild();
            if (!(lastChild instanceof PsiTypeElement)) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (!(type2 instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (!wildcardType.isExtends()) {
                return;
            }
            PsiTypeElement extendsBound = (PsiTypeElement)typeElement.getLastChild();
            if (extendsBound.getAnnotations().length > 0 || !TypeUtils.isJavaLangObject(extendsBound.getType())) {
                return;
            }
            PsiElement firstChild = typeElement.getFirstChild();
            if (firstChild == null) {
                return;
            }
            this.registerError(firstChild, 2);
        }
    }

    private static class ExtendsObjectFix
    extends InspectionGadgetsFix {
        private ExtendsObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("extends.object.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectFix", "doFix"));
            }
            PsiElement identifier = descriptor.getPsiElement();
            PsiElement parent = identifier.getParent();
            if (parent instanceof PsiTypeParameter) {
                PsiJavaCodeReferenceElement[] referenceElements;
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                PsiReferenceList extendsList = typeParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                    ExtendsObjectFix.deleteElement((PsiElement)referenceElement);
                }
            } else {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement child = typeElement.getLastChild();
                while (child != null) {
                    PsiJavaToken javaToken;
                    IElementType tokenType;
                    if (child instanceof PsiJavaToken && (tokenType = (javaToken = (PsiJavaToken)child).getTokenType()) == JavaTokenType.QUEST) {
                        return;
                    }
                    child.delete();
                    child = typeElement.getLastChild();
                }
            }
        }
    }
}

