/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryParenthesesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreClarifyingParentheses = false;
    public boolean ignoreParenthesesOnConditionals = false;
    public boolean ignoreParenthesesOnLambdaParameter = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryParenthesesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryParenthesesInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessary.parentheses.option", new Object[0]), "ignoreClarifyingParentheses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessary.parentheses.conditional.option", new Object[0]), "ignoreParenthesesOnConditionals");
        optionsPanel.addCheckbox("Ignore parentheses around single no formal type lambda parameter", "ignoreParenthesesOnLambdaParameter");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryParenthesesVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryParenthesesFix();
    }

    private class UnnecessaryParenthesesVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryParenthesesVisitor() {
        }

        public void visitParameterList(PsiParameterList list2) {
            PsiParameter parameter;
            super.visitParameterList(list2);
            if (!UnnecessaryParenthesesInspection.this.ignoreParenthesesOnLambdaParameter && list2.getParent() instanceof PsiLambdaExpression && list2.getParametersCount() == 1 && (parameter = list2.getParameters()[0]).getTypeElement() == null && list2.getFirstChild() != parameter && list2.getLastChild() != parameter) {
                this.registerError((PsiElement)list2, new Object[0]);
            }
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiConditionalExpression conditionalExpression;
            PsiExpression condition2;
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (UnnecessaryParenthesesInspection.this.ignoreParenthesesOnConditionals && parent instanceof PsiConditionalExpression && expression2 == (condition2 = (conditionalExpression = (PsiConditionalExpression)parent).getCondition())) {
                return;
            }
            if (!ParenthesesUtils.areParenthesesNeeded(expression2, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses)) {
                this.registerError((PsiElement)expression2, new Object[0]);
                return;
            }
            super.visitParenthesizedExpression(expression2);
        }
    }

    private class UnnecessaryParenthesesFix
    extends InspectionGadgetsFix {
        private UnnecessaryParenthesesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.parentheses.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryParenthesesInspection$UnnecessaryParenthesesFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiParameterList) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
                PsiParameterList parameterList = (PsiParameterList)element;
                String text2 = parameterList.getParameters()[0].getName() + "->{}";
                PsiLambdaExpression expression2 = (PsiLambdaExpression)factory.createExpressionFromText(text2, element);
                element.replace((PsiElement)expression2.getParameterList());
            } else {
                ParenthesesUtils.removeParentheses((PsiExpression)element, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses);
            }
        }
    }
}

