/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SafeLockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LockAcquiredButNotSafelyReleased" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SafeLockInspection", "getID"));
        }
        return "LockAcquiredButNotSafelyReleased";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("safe.lock.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SafeLockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        PsiType type2 = expression2.getType();
        assert (type2 != null);
        String text2 = type2.getPresentableText();
        String string = InspectionGadgetsBundle.message("safe.lock.problem.descriptor", text2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SafeLockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SafeLockVisitor();
    }

    private static enum LockType {
        READ,
        WRITE,
        REGULAR;

    }

    private static class UnlockVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsUnlock;
        private final PsiVariable variable;
        private final LockType type;

        private UnlockVisitor(@NotNull PsiVariable variable, @NotNull LockType type2) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "<init>"));
            }
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "<init>"));
            }
            this.variable = variable;
            this.type = type2;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "visitElement"));
            }
            if (!this.containsUnlock) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor", "visitMethodCallExpression"));
            }
            if (this.containsUnlock) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"unlock".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier instanceof PsiReferenceExpression) {
                if (this.type != LockType.REGULAR) {
                    return;
                }
                PsiReference reference = (PsiReference)qualifier;
                PsiElement target2 = reference.resolve();
                if (this.variable.equals(target2)) {
                    this.containsUnlock = true;
                }
            } else if (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifier;
                PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
                String methodName1 = methodExpression1.getReferenceName();
                if (this.type == LockType.READ && "readLock".equals(methodName1) || this.type == LockType.WRITE && "writeLock".equals(methodName1)) {
                    PsiExpression qualifierExpression2 = methodExpression1.getQualifierExpression();
                    if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                        return;
                    }
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
                    PsiElement target3 = referenceExpression.resolve();
                    if (this.variable.equals(target3)) {
                        this.containsUnlock = true;
                    }
                }
            }
        }

        boolean containsUnlock() {
            return this.containsUnlock;
        }
    }

    private static class SafeLockVisitor
    extends BaseInspectionVisitor {
        private SafeLockVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            LockType type2;
            PsiVariable boundVariable;
            PsiReferenceExpression referenceExpression;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SafeLockInspection$SafeLockVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression2);
            if (!SafeLockVisitor.isLockAcquireMethod(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 instanceof PsiReferenceExpression) {
                referenceExpression = (PsiReferenceExpression)qualifierExpression2;
                PsiElement target2 = referenceExpression.resolve();
                if (!(target2 instanceof PsiVariable)) {
                    return;
                }
                boundVariable = (PsiVariable)target2;
                type2 = LockType.REGULAR;
            } else if (qualifierExpression2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression2;
                PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
                String methodName = methodExpression1.getReferenceName();
                if ("readLock".equals(methodName)) {
                    type2 = LockType.READ;
                } else if ("writeLock".equals(methodName)) {
                    type2 = LockType.WRITE;
                } else {
                    return;
                }
                PsiExpression qualifierExpression1 = methodExpression1.getQualifierExpression();
                if (!(qualifierExpression1 instanceof PsiReferenceExpression)) {
                    return;
                }
                referenceExpression = (PsiReferenceExpression)qualifierExpression1;
                PsiElement target3 = referenceExpression.resolve();
                if (!(target3 instanceof PsiVariable)) {
                    return;
                }
                boundVariable = (PsiVariable)target3;
            } else {
                return;
            }
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
            if (statement2 == null) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
            while (nextStatement != null && !SafeLockVisitor.isSignificant(nextStatement)) {
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            if (!(nextStatement instanceof PsiTryStatement)) {
                this.registerError((PsiElement)expression2, referenceExpression);
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
            if (SafeLockVisitor.lockIsUnlockedInFinally(tryStatement, boundVariable, type2)) {
                return;
            }
            this.registerError((PsiElement)expression2, referenceExpression);
        }

        private static boolean isSignificant(@NotNull PsiStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SafeLockInspection$SafeLockVisitor", "isSignificant"));
            }
            final Ref result2 = new Ref((Object)Boolean.TRUE);
            statement2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitExpression(PsiExpression expression2) {
                    super.visitExpression(expression2);
                    result2.set((Object)Boolean.FALSE);
                    this.stopWalking();
                }
            });
            return (Boolean)result2.get() == false;
        }

        private static boolean lockIsUnlockedInFinally(PsiTryStatement tryStatement, PsiVariable boundVariable, LockType type2) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            UnlockVisitor visitor = new UnlockVisitor(boundVariable, type2);
            finallyBlock.accept((PsiElementVisitor)visitor);
            return visitor.containsUnlock();
        }

        private static boolean isLockAcquireMethod(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"lock".equals(methodName) && !"lockInterruptibly".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.concurrent.locks.Lock");
        }
    }
}

