/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynchronizeOnThisInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronize.on.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnThisInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean syncOnClass = (Boolean)infos[0];
        String string = InspectionGadgetsBundle.message(syncOnClass ? "synchronize.on.class.problem.descriptor" : "synchronize.on.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizeOnThisInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnThisVisitor();
    }

    private static class SynchronizeOnThisVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnThisVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizeOnThisInspection$SynchronizeOnThisVisitor", "visitSynchronizedStatement"));
            }
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression2 = ParenthesesUtils.stripParentheses(statement2.getLockExpression());
            if (lockExpression2 instanceof PsiThisExpression) {
                this.registerError((PsiElement)lockExpression2, Boolean.FALSE);
            } else if (SynchronizeOnThisVisitor.hasJavaLangClassType(lockExpression2)) {
                this.registerError((PsiElement)lockExpression2, Boolean.TRUE);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SynchronizeOnThisInspection$SynchronizeOnThisVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression2) && !ThreadingUtils.isWaitCall(expression2)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                this.registerMethodCallError(expression2, Boolean.FALSE);
            } else if (SynchronizeOnThisVisitor.hasJavaLangClassType(qualifier)) {
                this.registerMethodCallError(expression2, Boolean.TRUE);
            }
        }

        private static boolean hasJavaLangClassType(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType javaLangClassType = TypeUtils.getType("java.lang.Class", (PsiElement)expression2);
            if (!javaLangClassType.isAssignableFrom((PsiType)classType)) {
                return false;
            }
            PsiType[] parameters2 = classType.getParameters();
            if (parameters2.length == 0) {
                return true;
            }
            if (parameters2.length > 1) {
                return false;
            }
            PsiType parameterType = parameters2[0];
            if (SynchronizeOnThisVisitor.isPrivateClassType(parameterType)) {
                return true;
            }
            if (!(parameterType instanceof PsiCapturedWildcardType)) {
                return false;
            }
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)parameterType;
            PsiWildcardType wildcardType = capturedWildcardType.getWildcard();
            PsiType extendsBoundType = wildcardType.getExtendsBound();
            return SynchronizeOnThisVisitor.isPrivateClassType(extendsBoundType);
        }

        private static boolean isPrivateClassType(PsiType type2) {
            if (!(type2 instanceof PsiClassType)) {
                return false;
            }
            PsiClassType extendsBoundClassType = (PsiClassType)type2;
            PsiClass aClass = extendsBoundClassType.resolve();
            return aClass == null || !aClass.hasModifierProperty("private");
        }
    }
}

