/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class TypeParameterHidesVisibleTypeInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.hides.visible.type.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/TypeParameterHidesVisibleTypeInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass instanceof PsiTypeParameter) {
            String string = InspectionGadgetsBundle.message("type.parameter.hides.type.parameter.problem.descriptor", aClass.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/TypeParameterHidesVisibleTypeInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String name2 = aClass.getQualifiedName();
        if (name2 == null) {
            name2 = aClass.getName();
        }
        String string = InspectionGadgetsBundle.message("type.parameter.hides.visible.type.problem.descriptor", name2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/TypeParameterHidesVisibleTypeInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterHidesVisibleTypeVisitor();
    }

    private static class TypeParameterHidesVisibleTypeVisitor
    extends BaseInspectionVisitor {
        private TypeParameterHidesVisibleTypeVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            PsiClass aClass;
            super.visitTypeParameter(parameter);
            String unqualifiedClassName = parameter.getName();
            PsiTypeParameterListOwner context = parameter.getOwner();
            if (context == null) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)parameter.getProject()).getResolveHelper();
            while (true) {
                if (context.hasModifierProperty("static")) {
                    return;
                }
                if ((context = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)context, PsiTypeParameterListOwner.class)) == null) {
                    return;
                }
                aClass = resolveHelper.resolveReferencedClass(unqualifiedClassName, (PsiElement)context);
                if (aClass instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                    PsiTypeParameterListOwner owner2 = typeParameter.getOwner();
                    if (owner2 == null) {
                        return;
                    }
                    if (!owner2.equals(context)) continue;
                }
                if (aClass != null) break;
            }
            this.registerClassError((PsiClass)parameter, aClass);
        }
    }
}

