/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class CommentOnLineWithSourcePredicate
implements PsiElementPredicate {
    CommentOnLineWithSourcePredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        if (element instanceof PsiDocComment) {
            return false;
        }
        if (element.getTextOffset() == 0) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        if (comment instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)comment)) {
            return false;
        }
        IElementType type2 = comment.getTokenType();
        if (!JavaTokenType.C_STYLE_COMMENT.equals(type2) && !JavaTokenType.END_OF_LINE_COMMENT.equals(type2)) {
            return false;
        }
        PsiElement prevSibling = PsiTreeUtil.prevLeaf((PsiElement)element);
        if (prevSibling == null || prevSibling.getTextLength() == 0) {
            return false;
        }
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        String prevSiblingText = prevSibling.getText();
        if (prevSiblingText.indexOf(10) < 0 && prevSiblingText.indexOf(13) < 0) {
            return true;
        }
        PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)element);
        if (!(nextSibling instanceof PsiWhiteSpace)) {
            return true;
        }
        String nextSiblingText = nextSibling.getText();
        return nextSiblingText.indexOf(10) < 0 && nextSiblingText.indexOf(13) < 0;
    }
}

