/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;

class StringConcatPredicate
implements PsiElementPredicate {
    StringConcatPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        IElementType tokenType = token.getTokenType();
        if (!tokenType.equals(JavaTokenType.PLUS)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiType type2 = polyadicExpression.getType();
        if (type2 == null || !type2.equalsToText("java.lang.String")) {
            return false;
        }
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        PsiExpression previous = null;
        boolean stringTypeSeen = false;
        int length = operands2.length;
        for (int i2 = 0; i2 < length; ++i2) {
            PsiExpression operand2 = operands2[i2];
            PsiType operandType = operand2.getType();
            PsiJavaToken currentToken = polyadicExpression.getTokenBeforeOperand(operand2);
            if (token == currentToken) {
                if (!(previous instanceof PsiLiteralExpression) || !(operand2 instanceof PsiLiteralExpression)) {
                    return false;
                }
                return stringTypeSeen || i2 == 1 && operandType != null && operandType.equalsToText("java.lang.String");
            }
            previous = operand2;
            if (stringTypeSeen) continue;
            stringTypeSeen = operandType != null && operandType.equalsToText("java.lang.String");
        }
        return false;
    }
}

