/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IterableForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForEachLoopWithIteratorForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IterableForEachLoopPredicate iterableForEachLoopPredicate = new IterableForEachLoopPredicate();
        if (iterableForEachLoopPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIteratorForLoopIntention", "getElementPredicate"));
        }
        return iterableForEachLoopPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIteratorForLoopIntention", "processIntention"));
        }
        PsiForeachStatement statement2 = (PsiForeachStatement)element.getParent();
        if (statement2 == null) {
            return;
        }
        PsiExpression iteratedValue2 = statement2.getIteratedValue();
        if (iteratedValue2 == null) {
            return;
        }
        PsiType iteratedValueType = iteratedValue2.getType();
        if (!(iteratedValueType instanceof PsiClassType)) {
            return;
        }
        StringBuilder methodCall = new StringBuilder();
        if (ParenthesesUtils.getPrecedence(iteratedValue2) > 1) {
            methodCall.append('(').append(iteratedValue2.getText()).append(')');
        } else {
            methodCall.append(iteratedValue2.getText());
        }
        methodCall.append(".iterator()");
        Project project2 = statement2.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiExpression iteratorCall = factory.createExpressionFromText(methodCall.toString(), (PsiElement)iteratedValue2);
        PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
        if (variableType == null) {
            return;
        }
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String iterator = codeStyleManager.suggestUniqueVariableName("iterator", (PsiElement)statement2, true);
        newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
        newStatement.append(iterator).append(".hasNext();) {");
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
        if (codeStyleSettings.GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        PsiParameter iterationParameter = statement2.getIterationParameter();
        PsiType parameterType = iterationParameter.getType();
        String typeText = parameterType.getCanonicalText();
        newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
        PsiStatement body2 = statement2.getBody();
        if (body2 == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
            PsiElement[] children2 = block.getChildren();
            for (int i2 = 1; i2 < children2.length - 1; ++i2) {
                newStatement.append(children2[i2].getText());
            }
        } else {
            newStatement.append(body2.getText());
        }
        newStatement.append('}');
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement2, newStatement.toString());
    }
}

