/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReverseForLoopDirectionPredicate
implements PsiElementPredicate {
    ReverseForLoopDirectionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken keyword = (PsiJavaToken)element;
        IElementType tokenType = keyword.getTokenType();
        if (!JavaTokenType.FOR_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = keyword.getParent();
        if (!(parent instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)parent;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiLocalVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiType type2 = variable.getType();
        if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (!ReverseForLoopDirectionPredicate.isVariableCompared(variable, condition2)) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        return ReverseForLoopDirectionPredicate.isVariableIncrementOrDecremented(variable, update2);
    }

    public static boolean isVariableCompared(@NotNull PsiVariable variable, @Nullable PsiExpression expression2) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/forloop/ReverseForLoopDirectionPredicate", "isVariableCompared"));
        }
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!ComparisonUtils.isComparisonOperation(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        if (VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
            return true;
        }
        return VariableAccessUtils.evaluatesToVariable(rhs, variable);
    }

    public static boolean isVariableIncrementOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement2) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/forloop/ReverseForLoopDirectionPredicate", "isVariableIncrementOrDecremented"));
        }
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand2 = prefixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand2, variable);
        }
        if (expression2 instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression2;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand3 = postfixExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand3, variable);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs = ParenthesesUtils.stripParentheses(lhs), variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType token = binaryExpression.getOperationTokenType();
                if (!token.equals(JavaTokenType.PLUS) && !token.equals(JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                lOperand = ParenthesesUtils.stripParentheses(lOperand);
                PsiExpression rOperand = binaryExpression.getROperand();
                if (VariableAccessUtils.evaluatesToVariable(rOperand = ParenthesesUtils.stripParentheses(rOperand), variable)) {
                    return true;
                }
                if (VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                    return true;
                }
            } else if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ) {
                return true;
            }
        }
        return false;
    }
}

