/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.increment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

class IncrementUtil {
    IncrementUtil() {
    }

    @Nullable
    @Contract(value="null -> null")
    static String getOperatorText(@Nullable PsiElement element) {
        if (element instanceof PsiPostfixExpression) {
            return ((PsiPostfixExpression)element).getOperationSign().getText();
        }
        if (element instanceof PsiPrefixExpression) {
            return ((PsiPrefixExpression)element).getOperationSign().getText();
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    static PsiReferenceExpression getIncrementOrDecrementOperand(@Nullable PsiElement element) {
        if (element instanceof PsiPostfixExpression) {
            PsiPostfixExpression expression2 = (PsiPostfixExpression)element;
            return IncrementUtil.getIncrementOrDecrementOperand(expression2.getOperationTokenType(), expression2.getOperand());
        }
        if (element instanceof PsiPrefixExpression) {
            PsiPrefixExpression expression3 = (PsiPrefixExpression)element;
            return IncrementUtil.getIncrementOrDecrementOperand(expression3.getOperationTokenType(), expression3.getOperand());
        }
        return null;
    }

    @Nullable
    private static PsiReferenceExpression getIncrementOrDecrementOperand(@Nullable IElementType tokenType, @Nullable PsiExpression operand2) {
        PsiExpression bareOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2);
        if (bareOperand instanceof PsiReferenceExpression && (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType))) {
            return (PsiReferenceExpression)bareOperand;
        }
        return null;
    }
}

