/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.modifiers.ModifierPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ModifierIntention
extends Intention
implements LowPriorityAction {
    ModifierIntention() {
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/siyeh/ipp/modifiers/ModifierIntention", "getElementToMakeWritable"));
        }
        return currentFile;
    }

    @Override
    @NotNull
    protected final PsiElementPredicate getElementPredicate() {
        ModifierPredicate modifierPredicate = new ModifierPredicate(this.getModifier());
        if (modifierPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/modifiers/ModifierIntention", "getElementPredicate"));
        }
        return modifierPredicate;
    }

    @Override
    protected final void processIntention(@NotNull PsiElement element) {
        boolean conflictsDialogOK;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/modifiers/ModifierIntention", "processIntention"));
        }
        PsiMember member = (PsiMember)element.getParent();
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return;
        }
        MultiMap<PsiElement, String> conflicts = this.checkForConflicts(member);
        Project project2 = member.getProject();
        if (conflicts.isEmpty()) {
            conflictsDialogOK = true;
        } else {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project2, conflicts, () -> this.changeModifier(modifierList));
            conflictsDialogOK = conflictsDialog.showAndGet();
        }
        if (conflictsDialogOK) {
            this.changeModifier(modifierList);
        }
    }

    private void changeModifier(PsiModifierList modifierList) {
        WriteAction.run(() -> {
            String modifier = this.getModifier();
            modifierList.setModifierProperty(modifier, true);
            if (!"packageLocal".equals(modifier)) {
                Project project2 = modifierList.getProject();
                PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project2).createWhiteSpaceFromText(" ");
                PsiElement sibling = modifierList.getNextSibling();
                if (sibling instanceof PsiWhiteSpace) {
                    sibling.replace(whitespace);
                    CodeStyleManager.getInstance((Project)project2).reformatRange(modifierList.getParent(), modifierList.getTextOffset(), modifierList.getNextSibling().getTextOffset());
                }
            }
        });
    }

    private MultiMap<PsiElement, String> checkForConflicts(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/siyeh/ipp/modifiers/ModifierIntention", "checkForConflicts"));
        }
        if (member instanceof PsiClass && this.getModifier().equals("public")) {
            String className;
            PsiClass aClass = (PsiClass)member;
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return MultiMap.emptyInstance();
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent;
            String name2 = FileUtil.getNameWithoutExtension((String)javaFile.getName());
            if (name2.equals(className = aClass.getName())) {
                return MultiMap.emptyInstance();
            }
            MultiMap conflicts = new MultiMap();
            conflicts.putValue((Object)aClass, (Object)IntentionPowerPackBundle.message("0.is.declared.in.1.but.when.public.should.be.declared.in.a.file.named.2", RefactoringUIUtil.getDescription((PsiElement)aClass, false), RefactoringUIUtil.getDescription((PsiElement)javaFile, false), CommonRefactoringUtil.htmlEmphasize((String)(className + ".java"))));
            return conflicts;
        }
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("private")) {
            return MultiMap.emptyInstance();
        }
        MultiMap conflicts = new MultiMap();
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            SuperMethodsSearch.search((PsiMethod)method, (PsiClass)method.getContainingClass(), (boolean)true, (boolean)false).forEach(methodSignature -> {
                PsiMethod superMethod = methodSignature.getMethod();
                if (!this.hasCompatibleVisibility(superMethod, true)) {
                    conflicts.putValue((Object)superMethod, (Object)IntentionPowerPackBundle.message("0.will.have.incompatible.access.privileges.with.super.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)superMethod, true)));
                }
                return true;
            });
            OverridingMethodsSearch.search((PsiMethod)method).forEach(overridingMethod -> {
                if (!this.isVisibleFromOverridingMethod(method, (PsiMethod)overridingMethod)) {
                    conflicts.putValue(overridingMethod, (Object)IntentionPowerPackBundle.message("0.will.no.longer.be.visible.from.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                } else if (!this.hasCompatibleVisibility((PsiMethod)overridingMethod, false)) {
                    conflicts.putValue(overridingMethod, (Object)IntentionPowerPackBundle.message("0.will.have.incompatible.access.privileges.with.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                }
                return false;
            });
        }
        PsiModifierList modifierListCopy = (PsiModifierList)modifierList.copy();
        modifierListCopy.setModifierProperty(this.getModifier(), true);
        Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope());
        search.forEach(reference -> {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/siyeh/ipp/modifiers/ModifierIntention", "lambda$checkForConflicts$4"));
            }
            PsiElement element = reference.getElement();
            if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), modifierListCopy, element, null, null)) {
                return true;
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
            if (context == null) {
                return true;
            }
            conflicts.putValue((Object)element, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, false), PsiBundle.visibilityPresentation((String)this.getModifier()), RefactoringUIUtil.getDescription(context, true)}));
            return true;
        });
        return conflicts;
    }

    private boolean hasCompatibleVisibility(PsiMethod method, boolean isSuper) {
        if (this.getModifier().equals("private")) {
            return false;
        }
        if (this.getModifier().equals("packageLocal")) {
            if (isSuper) {
                return !method.hasModifierProperty("public") && !method.hasModifierProperty("protected");
            }
            return true;
        }
        if (this.getModifier().equals("protected")) {
            if (isSuper) {
                return !method.hasModifierProperty("public");
            }
            return method.hasModifierProperty("protected") || method.hasModifierProperty("public");
        }
        if (this.getModifier().equals("public")) {
            if (!isSuper) {
                return method.hasModifierProperty("public");
            }
            return true;
        }
        throw new AssertionError();
    }

    private boolean isVisibleFromOverridingMethod(PsiMethod method, PsiMethod overridingMethod) {
        PsiModifierList modifierListCopy = (PsiModifierList)method.getModifierList().copy();
        modifierListCopy.setModifierProperty(this.getModifier(), true);
        return JavaResolveUtil.isAccessible((PsiMember)method, method.getContainingClass(), modifierListCopy, (PsiElement)overridingMethod, null, null);
    }

    @VisibilityConstant
    protected abstract String getModifier();

    static @interface VisibilityConstant {
    }
}

