/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.shift;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;

class ShiftUtils {
    private ShiftUtils() {
    }

    public static boolean isPowerOfTwo(PsiExpression rhs) {
        if (!(rhs instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literal = (PsiLiteralExpression)rhs;
        Object value2 = literal.getValue();
        if (!(value2 instanceof Number)) {
            return false;
        }
        if (value2 instanceof Double || value2 instanceof Float) {
            return false;
        }
        int intValue = ((Number)value2).intValue();
        if (intValue <= 0) {
            return false;
        }
        while (intValue % 2 == 0) {
            intValue >>= 1;
        }
        return intValue == 1;
    }

    public static int getLogBase2(PsiExpression rhs) {
        PsiLiteralExpression literal = (PsiLiteralExpression)rhs;
        Object value2 = literal.getValue();
        int intValue = ((Number)value2).intValue();
        int log = 0;
        while (intValue % 2 == 0) {
            intValue >>= 1;
            ++log;
        }
        return log;
    }

    public static int getExpBase2(PsiExpression rhs) {
        PsiLiteralExpression literal = (PsiLiteralExpression)rhs;
        Object value2 = literal.getValue();
        if (value2 == null) {
            return 0;
        }
        int intValue = ((Number)value2).intValue() & 0x1F;
        int exp = 1;
        for (int i2 = 0; i2 < intValue; ++i2) {
            exp <<= 1;
        }
        return exp;
    }

    public static boolean isIntegral(PsiType lhsType) {
        return lhsType != null && (lhsType.equals(PsiType.INT) || lhsType.equals(PsiType.SHORT) || lhsType.equals(PsiType.LONG) || lhsType.equals(PsiType.BYTE));
    }

    public static boolean isIntLiteral(PsiExpression rhs) {
        if (!(rhs instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literal = (PsiLiteralExpression)rhs;
        Object value2 = literal.getValue();
        if (!(value2 instanceof Number)) {
            return false;
        }
        return !(value2 instanceof Double) && !(value2 instanceof Float);
    }
}

