/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToNestedIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiReturnStatement)) {
                    return false;
                }
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (!(returnValue instanceof PsiPolyadicExpression)) {
                    return false;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)returnValue;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                return tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention", "processIntention"));
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)element;
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null || ErrorUtil.containsDeepError((PsiElement)returnValue)) {
            return;
        }
        String newStatementText = ConvertToNestedIfIntention.buildIf(returnValue, true, new StringBuilder()).toString();
        Project project2 = returnStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{" + newStatementText + "}", (PsiElement)returnStatement);
        PsiElement parent = returnStatement.getParent();
        for (PsiStatement st : blockStatement.getCodeBlock().getStatements()) {
            CodeStyleManager.getInstance((Project)project2).reformat(parent.addBefore((PsiElement)st, (PsiElement)returnStatement));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)returnStatement, "return false;");
    }

    private static StringBuilder buildIf(@Nullable PsiExpression expression2, boolean top, StringBuilder out) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                for (PsiExpression operand2 : operands2) {
                    ConvertToNestedIfIntention.buildIf(operand2, false, out);
                }
                if (top && !StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) {
                    out.append("return true;");
                }
                return out;
            }
            if (top && JavaTokenType.OROR.equals(tokenType)) {
                for (PsiExpression operand3 : operands2) {
                    ConvertToNestedIfIntention.buildIf(operand3, false, out);
                    if (StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) continue;
                    out.append("return true;");
                }
                return out;
            }
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            ConvertToNestedIfIntention.buildIf(parenthesizedExpression.getExpression(), top, out);
            return out;
        }
        if (expression2 != null) {
            out.append("if(").append(expression2.getText()).append(")");
        }
        return out;
    }
}

