/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeParallelIfsPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeParallelIfsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeParallelIfsPredicate mergeParallelIfsPredicate = new MergeParallelIfsPredicate();
        if (mergeParallelIfsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/MergeParallelIfsIntention", "getElementPredicate"));
        }
        return mergeParallelIfsPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token = (PsiJavaToken)element;
        PsiIfStatement firstStatement = (PsiIfStatement)token.getParent();
        PsiIfStatement secondStatement = (PsiIfStatement)PsiTreeUtil.skipSiblingsForward((PsiElement)firstStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        String statement2 = MergeParallelIfsIntention.mergeIfStatements(firstStatement, secondStatement);
        assert (firstStatement != null);
        PsiReplacementUtil.replaceStatement((PsiStatement)firstStatement, statement2);
        assert (secondStatement != null);
        secondStatement.delete();
    }

    private static String mergeIfStatements(PsiIfStatement firstStatement, PsiIfStatement secondStatement) {
        PsiExpression condition2 = firstStatement.getCondition();
        String conditionText = condition2 == null ? "" : condition2.getText();
        PsiStatement firstThenBranch = firstStatement.getThenBranch();
        PsiStatement secondThenBranch = secondStatement.getThenBranch();
        String statement2 = "if(" + conditionText + ')' + MergeParallelIfsIntention.printStatementsInSequence(firstThenBranch, secondThenBranch);
        PsiStatement firstElseBranch = firstStatement.getElseBranch();
        PsiStatement secondElseBranch = secondStatement.getElseBranch();
        if (firstElseBranch != null || secondElseBranch != null) {
            statement2 = firstElseBranch instanceof PsiIfStatement && secondElseBranch instanceof PsiIfStatement && MergeParallelIfsPredicate.ifStatementsCanBeMerged((PsiIfStatement)firstElseBranch, (PsiIfStatement)secondElseBranch) ? statement2 + "else " + MergeParallelIfsIntention.mergeIfStatements((PsiIfStatement)firstElseBranch, (PsiIfStatement)secondElseBranch) : statement2 + "else" + MergeParallelIfsIntention.printStatementsInSequence(firstElseBranch, secondElseBranch);
        }
        return statement2;
    }

    private static String printStatementsInSequence(PsiStatement statement1, PsiStatement statement2) {
        if (statement1 == null) {
            return ' ' + statement2.getText();
        }
        if (statement2 == null) {
            return ' ' + statement1.getText();
        }
        StringBuilder out = new StringBuilder();
        out.append('{');
        MergeParallelIfsIntention.printStatementStripped(statement1, out);
        MergeParallelIfsIntention.printStatementStripped(statement2, out);
        out.append('}');
        return out.toString();
    }

    private static void printStatementStripped(PsiStatement statement2, StringBuilder out) {
        if (statement2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)statement2).getCodeBlock();
            PsiElement[] children2 = block.getChildren();
            for (int i2 = 1; i2 < children2.length - 1; ++i2) {
                out.append(children2[i2].getText());
            }
        } else {
            out.append(statement2.getText());
        }
    }
}

