/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.varargs.VarargArgumentsPredicate;
import org.jetbrains.annotations.NotNull;

public class WrapVarargArgumentsWithExplicitArrayIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        VarargArgumentsPredicate varargArgumentsPredicate = new VarargArgumentsPredicate();
        if (varargArgumentsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/varargs/WrapVarargArgumentsWithExplicitArrayIntention", "getElementPredicate"));
        }
        return varargArgumentsPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/varargs/WrapVarargArgumentsWithExplicitArrayIntention", "processIntention"));
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (methodCallExpression == null) {
            return;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodExpressionText = methodExpression.getText();
        StringBuilder newExpression = new StringBuilder(methodExpressionText);
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        newExpression.append('(');
        int varargParameterIndex = parametersCount - 1;
        for (int i2 = 0; i2 < varargParameterIndex; ++i2) {
            newExpression.append(arguments[i2].getText()).append(", ");
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiParameter varargParameter = parameters2[varargParameterIndex];
        PsiArrayType type2 = (PsiArrayType)varargParameter.getType();
        newExpression.append("new ");
        PsiType componentType = type2.getComponentType();
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType substitutedType = substitutor.substitute(componentType);
        if (substitutedType instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)substitutedType;
            PsiType bound = capturedWildcardType.getLowerBound();
            newExpression.append(bound.getCanonicalText());
        } else {
            newExpression.append(substitutedType.getCanonicalText());
        }
        newExpression.append("[]{");
        if (arguments.length > varargParameterIndex) {
            newExpression.append(arguments[varargParameterIndex].getText());
            for (int i3 = parametersCount; i3 < arguments.length; ++i3) {
                newExpression.append(", ").append(arguments[i3].getText());
            }
        }
        newExpression.append("})");
        PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
    }
}

