/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWhileLoopWithDoWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        WhileLoopPredicate whileLoopPredicate = new WhileLoopPredicate();
        if (whileLoopPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/whileloop/ReplaceWhileLoopWithDoWhileLoopIntention", "getElementPredicate"));
        }
        return whileLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/whileloop/ReplaceWhileLoopWithDoWhileLoopIntention", "processIntention"));
        }
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiStatement body2 = whileStatement.getBody();
        PsiExpression condition2 = whileStatement.getCondition();
        boolean infiniteLoop = BoolUtils.isTrue(condition2);
        StringBuilder doWhileStatementText = new StringBuilder();
        if (!infiniteLoop) {
            doWhileStatementText.append("if(");
            if (condition2 != null) {
                doWhileStatementText.append(condition2.getText());
            }
            doWhileStatementText.append(") {\n");
        }
        if (body2 instanceof PsiBlockStatement) {
            doWhileStatementText.append("do {");
            PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children2 = codeBlock.getChildren();
            if (children2.length > 2) {
                for (int i2 = 1; i2 < children2.length - 1; ++i2) {
                    PsiElement child = children2[i2];
                    doWhileStatementText.append(child.getText());
                }
            }
            doWhileStatementText.append('}');
        } else if (body2 != null) {
            doWhileStatementText.append("do ").append(body2.getText()).append('\n');
        }
        doWhileStatementText.append("while(");
        if (condition2 != null) {
            doWhileStatementText.append(condition2.getText());
        }
        doWhileStatementText.append(");");
        if (!infiniteLoop) {
            doWhileStatementText.append("\n}");
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)whileStatement, doWhileStatementText.toString());
    }
}

