/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTagGroup
extends ActionGroup {
    public AddTagGroup() {
        this.setPopup(true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/AddTagGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        Project project2 = e.getProject();
        final ImageTagManager tagManager = ImageTagManager.getInstance(project2);
        List<String> tags = tagManager.getAllTags();
        int tagsNumber = tags.size();
        AnAction[] actions = new AnAction[tagsNumber + 1];
        for (int i2 = 0; i2 < tagsNumber; ++i2) {
            final String tag = tags.get(i2);
            actions[i2] = new AnAction(tag){

                public void actionPerformed(AnActionEvent e) {
                    ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
                    if (view != null) {
                        for (VirtualFile file2 : view.getSelection()) {
                            tagManager.addTag(tag, file2);
                        }
                    }
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabledAndVisible(false);
                    ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
                    if (view != null) {
                        e.getPresentation().setEnabledAndVisible(Arrays.stream(view.getSelection()).noneMatch(file2 -> tagManager.hasTag(tag, (VirtualFile)file2)));
                    }
                }
            };
        }
        actions[tagsNumber] = new AnAction("New Tag"){

            public void actionPerformed(AnActionEvent e) {
                String tag;
                VirtualFile[] selection;
                ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
                if (view != null && (selection = view.getSelection()).length > 0 && (tag = Messages.showInputDialog((String)"", (String)"New Tag Name", null)) != null) {
                    for (VirtualFile file2 : selection) {
                        tagManager.addTag(tag, file2);
                    }
                }
            }
        };
        if (actions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/AddTagGroup", "getChildren"));
        }
        return actions;
    }
}

