/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveTagGroup
extends ActionGroup {
    public RemoveTagGroup() {
        this.setPopup(true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/RemoveTagGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        Project project2 = e.getProject();
        final ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        final ImageTagManager tagManager = ImageTagManager.getInstance(project2);
        if (view != null) {
            ArrayList<String> tags = null;
            for (VirtualFile file2 : view.getSelection()) {
                List<String> newTags = tagManager.getTags(file2);
                if (newTags.isEmpty()) {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/RemoveTagGroup", "getChildren"));
                    }
                    return EMPTY_ARRAY;
                }
                if (tags == null) {
                    tags = new ArrayList<String>(newTags);
                    continue;
                }
                tags.retainAll(newTags);
            }
            if (tags == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/RemoveTagGroup", "getChildren"));
                }
                return EMPTY_ARRAY;
            }
            AnAction[] anActionArray = (AnAction[])tags.stream().map(tag -> new AnAction((String)tag, (String)tag){
                final /* synthetic */ String val$tag;
                {
                    this.val$tag = string;
                    super(arg0);
                }

                public void actionPerformed(AnActionEvent e) {
                    for (VirtualFile file2 : view.getSelection()) {
                        tagManager.removeTag(this.val$tag, file2);
                    }
                }
            }).toArray(AnAction[]::new);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/RemoveTagGroup", "getChildren"));
            }
            return anActionArray;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/thumbnail/actions/RemoveTagGroup", "getChildren"));
        }
        return EMPTY_ARRAY;
    }
}

