/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpForm {
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private static final JBColor BACKGROUND_COLOR_MATCH = new JBColor(15203035, 0x445542);
    private static final JBColor BACKGROUND_COLOR_NOMATCH = new JBColor(16757152, 7220008);
    private final PsiFile myRegexpFile;
    private EditorTextField mySampleText;
    private EditorTextField myRegExp;
    private JPanel myRootPanel;
    private JBLabel myMessage;
    private Project myProject;

    public CheckRegExpForm(@NotNull PsiFile regexpFile) {
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "<init>"));
        }
        this.myRegexpFile = regexpFile;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.myProject = this.myRegexpFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myRegexpFile);
        Language language = this.myRegexpFile.getLanguage();
        Object fileType = language instanceof RegExpLanguage ? RegExpLanguage.INSTANCE.getAssociatedFileType() : new RegExpFileType(language);
        this.myRegExp = new EditorTextField(document, this.myProject, (FileType)fileType);
        String sampleText = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_EDITED_REGEXP, "Sample Text");
        this.mySampleText = new EditorTextField(sampleText, this.myProject, (FileType)PlainTextFileType.INSTANCE){

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/regexp/intention/CheckRegExpForm$1", "updateBorder"));
                }
                this.setupBorder(editor);
            }
        };
        this.mySampleText.setOneLineMode(false);
        int preferredWidth = Math.max(JBUI.scale((int)250), this.myRegExp.getPreferredSize().width);
        this.myRegExp.setPreferredWidth(preferredWidth);
        this.mySampleText.setPreferredWidth(preferredWidth);
        this.myRootPanel = new JPanel(new BorderLayout()){
            Disposable disposable;
            Alarm updater;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = Disposer.newDisposable();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        IdeFocusManager.findInstance().requestFocus((Component)CheckRegExpForm.this.myRegExp.getFocusTarget(), true);
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)((Object)CheckRegExpForm.this.mySampleText));
                this.updater = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
                DocumentListener documentListener = new DocumentListener(){

                    public void documentChanged(DocumentEvent e) {
                        this.update();
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener(documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener(documentListener);
                this.update();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            public void update() {
                TransactionId transactionId = TransactionGuard.getInstance().getContextTransaction();
                this.updater.cancelAllRequests();
                if (!this.updater.isDisposed()) {
                    this.updater.addRequest(() -> {
                        RegExpMatchResult result2 = CheckRegExpForm.isMatchingText(CheckRegExpForm.this.myRegexpFile, CheckRegExpForm.this.mySampleText.getText());
                        TransactionGuard.getInstance().submitTransaction((Disposable)CheckRegExpForm.this.myProject, transactionId, () -> CheckRegExpForm.this.setBalloonState(result2));
                    }, 200);
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)CheckRegExpForm.this.myProject).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
    }

    void setBalloonState(RegExpMatchResult result2) {
        this.mySampleText.setBackground((Color)(result2 == RegExpMatchResult.MATCHES ? BACKGROUND_COLOR_MATCH : BACKGROUND_COLOR_NOMATCH));
        switch (result2) {
            case MATCHES: {
                this.myMessage.setText("Matches!");
                break;
            }
            case NO_MATCH: {
                this.myMessage.setText("No match");
                break;
            }
            case TIMEOUT: {
                this.myMessage.setText("Pattern is too complex");
                break;
            }
            case BAD_REGEXP: {
                this.myMessage.setText("Bad pattern");
            }
        }
        this.myRootPanel.revalidate();
        Balloon balloon = JBPopupFactory.getInstance().getParentBalloonFor((Component)this.myRootPanel);
        if (balloon != null && !balloon.isDisposed()) {
            balloon.revalidate();
        }
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.mySampleText;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpForm", "getPreferredFocusedComponent"));
        }
        return editorTextField;
    }

    @NotNull
    public JPanel getRootPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpForm", "getRootPanel"));
        }
        return jPanel;
    }

    public static boolean isMatchingTextTest(@NotNull PsiFile regexpFile, @NotNull String sampleText) {
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingTextTest"));
        }
        if (sampleText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleText", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingTextTest"));
        }
        RegExpMatchResult result2 = CheckRegExpForm.isMatchingText(regexpFile, sampleText);
        return result2 != null && result2 == RegExpMatchResult.MATCHES;
    }

    static RegExpMatchResult isMatchingText(@NotNull PsiFile regexpFile, @NotNull String sampleText) {
        RegExpMatchResult result2;
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingText"));
        }
        if (sampleText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleText", "org/intellij/lang/regexp/intention/CheckRegExpForm", "isMatchingText"));
        }
        String regExp = regexpFile.getText();
        Language regexpFileLanguage = regexpFile.getLanguage();
        RegExpMatcherProvider matcherProvider = (RegExpMatcherProvider)RegExpMatcherProvider.EP.forLanguage(regexpFileLanguage);
        if (matcherProvider != null && (result2 = (RegExpMatchResult)((Object)ReadAction.compute(() -> {
            if (regexpFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "lambda$isMatchingText$0"));
            }
            if (sampleText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampleText", "org/intellij/lang/regexp/intention/CheckRegExpForm", "lambda$isMatchingText$0"));
            }
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
            if (host != null) {
                return matcherProvider.matches(regExp, regexpFile, (PsiElement)host, sampleText, 1000L);
            }
            return null;
        }))) != null) {
            return result2;
        }
        Integer patternFlags = (Integer)ReadAction.compute(() -> {
            int flags;
            block2: {
                RegExpModifierProvider provider;
                if (regexpFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "lambda$isMatchingText$1"));
                }
                PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
                flags = 0;
                if (host == null) break block2;
                Iterator iterator = RegExpModifierProvider.EP.allForLanguage(host.getLanguage()).iterator();
                while (iterator.hasNext() && (flags = (provider = (RegExpModifierProvider)iterator.next()).getFlags((PsiElement)host, regexpFile)) <= 0) {
                }
            }
            return flags;
        });
        try {
            return Pattern.compile(regExp, patternFlags).matcher(StringUtil.newBombedCharSequence((CharSequence)sampleText, (long)1000L)).matches() ? RegExpMatchResult.MATCHES : RegExpMatchResult.NO_MATCH;
        }
        catch (ProcessCanceledException pc) {
            return RegExpMatchResult.TIMEOUT;
        }
        catch (Exception exception) {
            return RegExpMatchResult.BAD_REGEXP;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        this.createUIComponents();
        JPanel jPanel = this.myRootPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMessage = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Red means I can't hear you!");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("RegExp:");
        jLabel.setPreferredSize(new Dimension(55, 16));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Sample:");
        jLabel2.setPreferredSize(new Dimension(55, 16));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myRegExp;
        jPanel.add((Component)((Object)editorTextField), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        EditorTextField editorTextField2 = this.mySampleText;
        jPanel.add((Component)((Object)editorTextField2), new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

