/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.NetUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.TokenGenerator;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b\u001a*\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%\u001a\u0010\u0010$\u001a\u0004\u0018\u00010'2\u0006\u0010&\u001a\u00020'\u001a\b\u0010(\u001a\u00020\u0016H\u0000\u001a\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u0001H\u0000\u001a\u001a\u0010+\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020.H\u0002\u001a \u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001f\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0016\u001a\n\u00104\u001a\u00020\u0016*\u000201\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0010\u0010\u0011\"N\u0010\u0013\u001aB\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016 \u0015* \u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"IDE_TOKEN_FILE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "STANDARD_COOKIE", "Lio/netty/handler/codec/http/cookie/DefaultCookie;", "getSTANDARD_COOKIE", "()Lio/netty/handler/codec/http/cookie/DefaultCookie;", "STANDARD_COOKIE$delegate", "Lkotlin/Lazy;", "TOKEN_HEADER_NAME", "TOKEN_PARAM_NAME", "notificationManager", "Lcom/intellij/notification/SingletonNotificationManager;", "getNotificationManager", "()Lcom/intellij/notification/SingletonNotificationManager;", "notificationManager$delegate", "tokens", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "", "acquireToken", "compareNameAndProjectBasePath", "projectName", "project", "Lcom/intellij/openapi/project/Project;", "doProcess", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectNameAsHost", "findIndexFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "basedir", "Ljava/nio/file/Path;", "isActivatable", "isOwnHostName", "host", "toIdeaPath", "decodedPath", "offset", "", "validateToken", "Lio/netty/handler/codec/http/HttpHeaders;", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "isSignedRequest", "built-in-server"})
public final class BuiltInWebServerKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final Logger LOG;
    private static final String IDE_TOKEN_FILE = "user.web.token";
    private static final Lazy notificationManager$delegate;
    @NotNull
    public static final String TOKEN_PARAM_NAME = "_ijt";
    @NotNull
    public static final String TOKEN_HEADER_NAME = "x-ijt";
    private static final Lazy STANDARD_COOKIE$delegate;
    private static final Cache<String, Boolean> tokens;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(BuiltInWebServerKt.class, (String)"built-in-server"), "notificationManager", "getNotificationManager()Lcom/intellij/notification/SingletonNotificationManager;")), (KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(BuiltInWebServerKt.class, (String)"built-in-server"), "STANDARD_COOKIE", "getSTANDARD_COOKIE()Lio/netty/handler/codec/http/cookie/DefaultCookie;"))};
        LOG = Logger.getInstance(BuiltInWebServer.class);
        notificationManager$delegate = LazyKt.lazy((Function0)notificationManager.2.INSTANCE);
        STANDARD_COOKIE$delegate = LazyKt.lazy((Function0)STANDARD_COOKIE.2.INSTANCE);
        tokens = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final SingletonNotificationManager getNotificationManager() {
        Lazy lazy = notificationManager$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (SingletonNotificationManager)lazy.getValue();
    }

    public static final boolean isActivatable() {
        return Registry.is((String)"ide.built.in.web.server.activatable", (boolean)false);
    }

    private static final DefaultCookie getSTANDARD_COOKIE() {
        Lazy lazy = STANDARD_COOKIE$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[1];
        return (DefaultCookie)lazy.getValue();
    }

    @NotNull
    public static final String acquireToken() {
        String token = (String)CollectionsKt.firstOrNull((Iterable)tokens.asMap().keySet());
        if (token == null) {
            token = TokenGenerator.INSTANCE.generate();
            tokens.put((Object)token, (Object)Boolean.TRUE);
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean doProcess(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context, String projectNameAsHost) {
        block18: {
            decodedPath = URLUtil.unescapePercentSequences((String)urlDecoder.path());
            offset = new Ref.IntRef();
            isEmptyPath = new Ref.BooleanRef();
            isCustomHost = projectNameAsHost != null;
            projectName = new Ref.ObjectRef();
            if (isCustomHost) {
                v0 = projectNameAsHost;
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                projectName.element = v0;
                offset.element = 0;
                var9_9 = decodedPath;
                var19_10 = isEmptyPath;
                var19_10.element = var20_11 = var9_9.length() == 0;
            } else {
                offset.element = StringsKt.indexOf$default((CharSequence)decodedPath, (char)'/', (int)1, (boolean)false, (int)4, null);
                var9_9 = decodedPath;
                var10_13 = 1;
                var11_15 = offset.element == -1 ? decodedPath.length() : offset.element;
                var19_10 = projectName;
                v1 = var9_9;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                v2 = v1.substring(var10_13, var11_15);
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var20_12 = v2;
                var19_10.element = var20_12;
                isEmptyPath.element = offset.element == -1;
            }
            candidateByDirectoryName = null;
            $receiver$iv = ProjectManager.getInstance().getOpenProjects();
            for (var12_17 = 0; var12_17 < $receiver$iv.length; ++var12_17) {
                block20: {
                    block21: {
                        block19: {
                            element$iv = $receiver$iv[var12_17];
                            project = (Project)element$iv;
                            if (!project.isDisposed()) break block19;
                            v3 = false;
                            break block20;
                        }
                        name = project.getName();
                        if (!isCustomHost) break block21;
                        if (!StringsKt.equals((String)((String)projectName.element), (String)name, (boolean)true)) ** GOTO lbl-1000
                        if (!SystemInfoRt.isFileSystemCaseSensitive) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            projectName.element = projectName.element;
                        }
                        v3 = true;
                        break block20;
                    }
                    v4 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"name");
                    if (!StringsKt.regionMatches((String)decodedPath, (int)1, (String)v4, (int)0, (int)name.length(), (boolean)(SystemInfoRt.isFileSystemCaseSensitive == false))) ** GOTO lbl-1000
                    v5 = isEmptyPathCandidate = decodedPath.length() == name.length() + 1;
                    if (isEmptyPathCandidate || decodedPath.charAt(name.length() + 1) == '/') {
                        projectName.element = name;
                        offset.element = name.length() + 1;
                        isEmptyPath.element = isEmptyPathCandidate;
                        v3 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (candidateByDirectoryName == null && BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName.element, project)) {
                            candidateByDirectoryName = project;
                        }
                        v3 = false;
                    }
                }
                if (!v3) continue;
                v6 = element$iv;
                break block18;
            }
            v6 = null;
        }
        if ((v7 = (Project)v6) == null) {
            v7 = candidateByDirectoryName;
        }
        if (v7 == null) {
            return false;
        }
        project = v7;
        if (BuiltInWebServerKt.isActivatable() && !PropertiesComponent.getInstance().getBoolean("ide.built.in.web.server.active")) {
            BuiltInWebServerKt.getNotificationManager().notify("Built-in web server is deactivated, to activate, please use Open in Browser", (Project)null);
            return false;
        }
        if (isEmptyPath.element) {
            v8 = (HttpRequest)request;
            v9 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"context.channel()");
            WebServerPathHandlerKt.redirectToDirectory(v8, v9, (String)projectName.element, null);
            return true;
        }
        v10 = decodedPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"decodedPath");
        path = BuiltInWebServerKt.toIdeaPath(v10, offset.element);
        if (path == null) {
            v11 = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"HttpResponseStatus.NOT_FOUND");
            v12 = Responses.orInSafeMode(HttpResponseStatus.BAD_REQUEST, v11);
            v13 = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"context.channel()");
            Responses.send$default(v12, v13, (HttpRequest)request, null, null, 12, null);
            return true;
        }
        var14_21 = (WebServerPathHandler[])WebServerPathHandler.Companion.getEP_NAME$built_in_server().getExtensions();
        for (var13_20 = 0; var13_20 < var14_21.length; ++var13_20) {
            pathHandler = var14_21[var13_20];
            $receiver$iv = BuiltInWebServerKt.LOG;
            try {
                if (!pathHandler.process(path, project, request, context, (String)projectName.element, decodedPath, isCustomHost)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
                continue;
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
        return false;
    }

    public static final boolean isSignedRequest(@NotNull HttpRequest $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return true;
        }
        String string2 = $receiver.headers().get(TOKEN_HEADER_NAME);
        if (string2 == null) {
            List list2 = (List)new QueryStringDecoder($receiver.uri()).parameters().get(TOKEN_PARAM_NAME);
            string2 = string = list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
        }
        if (string2 == null) {
            String string3 = NettyKt.getReferrer($receiver);
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                List list3 = (List)new QueryStringDecoder(it).parameters().get(TOKEN_PARAM_NAME);
                string = list3 != null ? (String)CollectionsKt.firstOrNull((List)list3) : null;
            } else {
                string = null;
            }
        }
        String token = string;
        return token != null && tokens.getIfPresent((Object)token) != null;
    }

    @Nullable
    public static final HttpHeaders validateToken(@NotNull HttpRequest request, @NotNull Channel channel, boolean isSignedRequest) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
        }
        String string = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (string != null) {
            String string2;
            String it = string2 = string;
            for (Cookie cookie : ServerCookieDecoder.STRICT.decode(it)) {
                if (!Intrinsics.areEqual((Object)cookie.name(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().name())) continue;
                if (!Intrinsics.areEqual((Object)cookie.value(), (Object)BuiltInWebServerKt.getSTANDARD_COOKIE().value())) break;
                return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
            }
        }
        if (isSignedRequest) {
            return new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)(ServerCookieEncoder.STRICT.encode((Cookie)BuiltInWebServerKt.getSTANDARD_COOKIE()) + "; SameSite=strict"));
        }
        QueryStringDecoder urlDecoder = new QueryStringDecoder(request.uri());
        if (!StringsKt.endsWith$default((String)urlDecoder.path(), (String)"/favicon.ico", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append("").append(NettyKt.getUriScheme(channel)).append("://");
            String string3 = NettyKt.getHost(request);
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String url = stringBuilder.append(string3).append("").append(urlDecoder.path()).toString();
            SwingUtilities.invokeAndWait(new Runnable(url){
                final /* synthetic */ String $url;

                public final void run() {
                    ProjectUtil.focusProjectWindow(null, true);
                    if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"", (String)("Page '" + StringUtil.trimMiddle((String)this.$url, (int)50) + "' requested without authorization, " + "\nyou can copy URL and open it in browser to trust it.")).icon(Messages.getWarningIcon())).yesText("Copy authorization URL to clipboard")).show() == 0) {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.$url + "?" + "_ijt" + "=" + BuiltInWebServerKt.acquireToken()));
                    }
                }
                {
                    this.$url = string;
                }
            });
        }
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
        Responses.send$default(Responses.orInSafeMode(HttpResponseStatus.UNAUTHORIZED, httpResponseStatus), channel, request, null, null, 12, null);
        return null;
    }

    private static final String toIdeaPath(String decodedPath, int offset) {
        String string;
        String string2 = string = decodedPath;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String path = string3;
        if (!StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            return null;
        }
        string = FileUtil.toCanonicalPath((String)path, (char)'/');
        int n = 1;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        return string5;
    }

    public static final boolean compareNameAndProjectBasePath(@NotNull String projectName, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        String basePath = project2.getBasePath();
        return basePath != null && FileUtilKt.endsWithName(basePath, projectName);
    }

    @Nullable
    public static final VirtualFile findIndexFile(@NotNull VirtualFile basedir) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        VirtualFile[] children2 = basedir.getChildren();
        if (children2 == null || (objectArray = (Object[])children2).length == 0) {
            return null;
        }
        Object[] elements$iv = new String[]{"index.", "default."};
        String[] stringArray = (String[])elements$iv;
        for (int i = 0; i < stringArray.length; ++i) {
            String indexNamePrefix = stringArray[i];
            VirtualFile index = null;
            String preferredName = indexNamePrefix + "html";
            for (int j = 0; j < children2.length; ++j) {
                VirtualFile child = children2[j];
                if (child.isDirectory()) continue;
                String name2 = child.getName();
                if (Intrinsics.areEqual((Object)name2, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name2, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final Path findIndexFile(@NotNull Path basedir) {
        Iterable iterable;
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull((Object)basedir, (String)"basedir");
        Path path = basedir;
        Function1 filter$iv = findIndexFile.children.1.INSTANCE;
        try {
            Iterable it22;
            block15: {
                void $receiver$iv;
                stringArray = filter$iv;
                stringArray = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter)new PathKt.sam.Filter.i.855e4f15((Function1)stringArray));
                boolean bl = false;
                try {
                    it22 = (DirectoryStream)stringArray;
                    it22 = CollectionsKt.toList((Iterable)it22);
                    if (stringArray == null) break block15;
                    stringArray.close();
                }
                catch (Exception it22) {
                    try {
                        bl = true;
                        try {
                            if (stringArray != null) {
                                stringArray.close();
                            }
                        }
                        catch (Exception $i$a$2$directoryStreamIfExists) {
                            // empty catch block
                        }
                        throw (Throwable)it22;
                    }
                    catch (Throwable it22) {
                        if (!bl) {
                            String[] stringArray2 = stringArray;
                            if (stringArray2 != null) {
                                stringArray2.close();
                            }
                        }
                        throw it22;
                    }
                }
            }
            iterable = it22;
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = null;
        }
        if (iterable == null) {
            return null;
        }
        Iterable children2 = iterable;
        Object[] elements$iv = new String[]{"index.", "default."};
        stringArray = (String[])elements$iv;
        for (int j = 0; j < stringArray.length; ++j) {
            String indexNamePrefix = stringArray[j];
            Path index = null;
            String preferredName = "" + indexNamePrefix + "html";
            for (Path child : children2) {
                if (PathKt.isDirectory((Path)child)) continue;
                String name2 = ((Object)child.getFileName()).toString();
                if (Intrinsics.areEqual((Object)name2, (Object)preferredName)) {
                    return child;
                }
                if (index != null || !StringsKt.startsWith$default((String)name2, (String)indexNamePrefix, (boolean)false, (int)2, null)) continue;
                index = child;
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    public static final boolean isOwnHostName(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (Intrinsics.areEqual((Object)host, (Object)address.getHostAddress()) || StringsKt.equals((String)host, (String)address.getCanonicalHostName(), (boolean)true)) {
                return true;
            }
            String localHostName = InetAddress.getLocalHost().getHostName();
            return StringsKt.equals((String)localHostName, (String)host, (boolean)true) || StringsKt.endsWith$default((String)host, (String)".local", (boolean)false, (int)2, null) && StringsKt.regionMatches((String)localHostName, (int)0, (String)host, (int)0, (int)(host.length() - ".local".length()), (boolean)true);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static final /* synthetic */ boolean access$doProcess(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectNameAsHost) {
        return BuiltInWebServerKt.doProcess(urlDecoder, request, context, projectNameAsHost);
    }
}

