/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBufUtf8Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiConditional;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiFsize;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiProcessorKt;
import org.jetbrains.builtInWebServer.ssi.SsiStopProcessingException;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0004J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0014\u0010\u0013\u001a\u00020\u00072\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\n\u0010\u000e\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0019\u001a\u00020\rH\u0004J1\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001b2\n\u0010\u000e\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0005\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/builtInWebServer/ssi/SsiProcessor;", "", "allowExec", "", "(Z)V", "commands", "", "", "Lorg/jetbrains/builtInWebServer/ssi/SsiCommand;", "charCmp", "buf", "", "index", "", "command", "isQuote", "c", "", "isSpace", "parseCommand", "instruction", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parseParamNames", "", "start", "parseParamValues", "", "count", "(Ljava/lang/StringBuilder;II)[Ljava/lang/String;", "process", "", "ssiExternalResolver", "Lorg/jetbrains/builtInWebServer/ssi/SsiExternalResolver;", "file", "Ljava/nio/file/Path;", "writer", "Lio/netty/buffer/ByteBufUtf8Writer;", "built-in-server"})
public final class SsiProcessor {
    private final Map<String, SsiCommand> commands = (Map)new THashMap();

    public final long process(@NotNull SsiExternalResolver ssiExternalResolver, @NotNull Path file2, @NotNull ByteBufUtf8Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)ssiExternalResolver, (String)"ssiExternalResolver");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        CharSequence fileContents = PathKt.readChars((Path)file2);
        long lastModifiedDate = PathKt.lastModified((Path)file2).toMillis();
        SsiProcessingState ssiProcessingState = new SsiProcessingState(ssiExternalResolver, lastModifiedDate);
        int index = 0;
        boolean inside = false;
        StringBuilder command = new StringBuilder();
        writer.ensureWritable((int)PathKt.size((Path)file2));
        try {
            while (index < fileContents.length()) {
                char c = fileContents.charAt(index);
                if (inside) {
                    if (c == SsiProcessorKt.getCOMMAND_END().charAt(0) && this.charCmp(fileContents, index, SsiProcessorKt.getCOMMAND_END())) {
                        long newLastModified;
                        String string;
                        Locale locale;
                        inside = false;
                        index += SsiProcessorKt.getCOMMAND_END().length();
                        String commandName = this.parseCommand(command);
                        if (SsiProcessorKt.getLOG().isDebugEnabled()) {
                            SsiProcessorKt.getLOG().debug("SSIProcessor.process -- processing command: " + commandName);
                        }
                        List<String> paramNames = this.parseParamNames(command, commandName.length());
                        String[] paramValues = this.parseParamValues(command, commandName.length(), paramNames.size());
                        String configErrMsg = ssiProcessingState.configErrorMessage;
                        String string2 = commandName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
                        Map<String, SsiCommand> map2 = this.commands;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(locale), (String)"(this as java.lang.String).toLowerCase(locale)");
                        SsiCommand ssiCommand = map2.get(string);
                        String errorMessage = null;
                        if (ssiCommand == null) {
                            errorMessage = "Unknown command: " + commandName;
                        } else if (paramValues == null) {
                            errorMessage = "Error parsing directive parameters.";
                        } else if (paramNames.size() != ((Object[])paramValues).length) {
                            errorMessage = "Parameter names count does not match parameter values count on command: " + commandName;
                        } else if ((!ssiProcessingState.conditionalState.processConditionalCommandsOnly || ssiCommand instanceof SsiConditional) && (newLastModified = ssiCommand.process(ssiProcessingState, commandName, paramNames, paramValues, writer)) > lastModifiedDate) {
                            lastModifiedDate = newLastModified;
                        }
                        if (errorMessage == null) continue;
                        SsiProcessorKt.getLOG().warn(errorMessage);
                        String string4 = configErrMsg;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"configErrMsg");
                        writer.write(string4);
                        continue;
                    }
                    command.append(c);
                    ++index;
                    continue;
                }
                if (c == SsiProcessorKt.getCOMMAND_START().charAt(0) && this.charCmp(fileContents, index, SsiProcessorKt.getCOMMAND_START())) {
                    inside = true;
                    index += SsiProcessorKt.getCOMMAND_START().length();
                    command.setLength(0);
                    continue;
                }
                if (!ssiProcessingState.conditionalState.processConditionalCommandsOnly) {
                    writer.append(c);
                }
                ++index;
            }
        }
        catch (SsiStopProcessingException ssiStopProcessingException) {
            // empty catch block
        }
        return lastModifiedDate;
    }

    @NotNull
    protected final List<String> parseParamNames(@NotNull StringBuilder command, int start) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        int bIdx = start;
        SmartList values = new SmartList();
        boolean inside = false;
        StringBuilder builder = new StringBuilder();
        while (bIdx < command.length()) {
            if (inside) {
                while (bIdx < command.length() && command.charAt(bIdx) != '=') {
                    builder.append(command.charAt(bIdx));
                    ++bIdx;
                }
                values.add((Object)builder.toString());
                builder.setLength(0);
                inside = false;
                int quotes = 0;
                boolean escaped = false;
                while (bIdx < command.length() && quotes != 2) {
                    char c = command.charAt(bIdx);
                    if (c == '\\' && !escaped) {
                        escaped = true;
                        ++bIdx;
                        continue;
                    }
                    if (c == '\"' && !escaped) {
                        ++quotes;
                    }
                    escaped = false;
                    ++bIdx;
                }
                continue;
            }
            while (bIdx < command.length() && this.isSpace(command.charAt(bIdx))) {
                ++bIdx;
            }
            if (bIdx >= command.length()) break;
            inside = true;
        }
        return (List)values;
    }

    @Nullable
    protected final String[] parseParamValues(@NotNull StringBuilder command, int start, int count) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        int valueIndex = 0;
        boolean inside = false;
        String[] values = new String[count];
        StringBuilder builder = new StringBuilder();
        char endQuote = (char)0;
        for (int bIdx = start; bIdx < command.length(); ++bIdx) {
            if (!inside) {
                while (bIdx < command.length() && !this.isQuote(command.charAt(bIdx))) {
                    ++bIdx;
                }
                if (bIdx >= command.length()) break;
                inside = true;
                endQuote = command.charAt(bIdx);
                continue;
            }
            boolean escaped = false;
            while (bIdx < command.length()) {
                char c = command.charAt(bIdx);
                if (c == '\\' && !escaped) {
                    escaped = true;
                    ++bIdx;
                    continue;
                }
                if (c == endQuote && !escaped) break;
                if (c == '$' && escaped) {
                    builder.append('\\');
                }
                escaped = false;
                builder.append(c);
                ++bIdx;
            }
            if (bIdx == command.length()) {
                return null;
            }
            values[valueIndex++] = builder.toString();
            builder.setLength(0);
            inside = false;
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseCommand(StringBuilder instruction) {
        String string;
        int firstLetter = -1;
        int lastLetter = -1;
        int n = 0;
        int n2 = instruction.length() - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                char c;
                if (Character.isLetter(c = instruction.charAt((int)i2))) {
                    if (firstLetter == -1) {
                        firstLetter = i2;
                    }
                    lastLetter = i2;
                } else if (!this.isSpace(c) || lastLetter > -1) break;
                if (i2 == n2) break;
                ++i2;
            }
        }
        if (firstLetter == -1) {
            string = "";
        } else {
            String string2 = instruction.substring(firstLetter, lastLetter + 1);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"instruction.substring(firstLetter, lastLetter + 1)");
        }
        return string;
    }

    protected final boolean charCmp(@NotNull CharSequence buf, int index, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return CharArrayUtil.regionMatches((CharSequence)buf, (int)index, (int)(index + command.length()), (CharSequence)command);
    }

    protected final boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    protected final boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    public SsiProcessor(boolean allowExec) {
        this.commands.put("config", 1.INSTANCE);
        this.commands.put("echo", 2.INSTANCE);
        this.commands.put("include", 3.INSTANCE);
        this.commands.put("flastmod", 4.INSTANCE);
        this.commands.put("fsize", new SsiFsize());
        this.commands.put("printenv", 5.INSTANCE);
        this.commands.put("set", 6.INSTANCE);
        SsiConditional ssiConditional = new SsiConditional();
        this.commands.put("if", ssiConditional);
        this.commands.put("elif", ssiConditional);
        this.commands.put("endif", ssiConditional);
        this.commands.put("else", ssiConditional);
    }
}

