/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011J?\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H$\u00a2\u0006\u0002\u0010\"J\u0019\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010&J/\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0$2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010%\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010 \u001a\u00020!H\u0016J\u0014\u0010-\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020(H\u0017J\u0015\u0010.\u001a\u00020\u00152\u0006\u0010%\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010/J\u0012\u00100\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020(J\n\u00101\u001a\u0006\u0012\u0002\b\u00030$J\\\u00102\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0016\u00103\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020(0$\u0018\u000104H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR6\u0010\t\u001a$\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u0000 \u000b*\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u00000\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00065"}, d2={"Lorg/jetbrains/debugger/BreakpointManagerBase;", "T", "Lorg/jetbrains/debugger/BreakpointBase;", "Lorg/jetbrains/debugger/BreakpointManager;", "()V", "breakpointDuplicationByTarget", "Ljava/util/concurrent/ConcurrentMap;", "getBreakpointDuplicationByTarget", "()Ljava/util/concurrent/ConcurrentMap;", "breakpoints", "", "kotlin.jvm.PlatformType", "", "getBreakpoints", "()Ljava/util/Set;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/debugger/BreakpointListener;", "getDispatcher", "()Lcom/intellij/util/EventDispatcher;", "addBreakpointListener", "", "listener", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;IZ)Lorg/jetbrains/debugger/BreakpointBase;", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "breakpoint", "(Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "(Lorg/jetbrains/debugger/BreakpointTarget;Lcom/intellij/util/Url;Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "enableBreakpoints", "flush", "notifyBreakpointResolvedListener", "(Lorg/jetbrains/debugger/BreakpointBase;)V", "remove", "removeAll", "setBreakpoint", "promiseRef", "Lcom/intellij/openapi/util/Ref;", "script-debugger-backend"})
public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    @NotNull
    private final Set<T> breakpoints = ContainerUtil.newConcurrentSet();
    @NotNull
    private final ConcurrentMap<T, T> breakpointDuplicationByTarget;
    @NotNull
    private final EventDispatcher<BreakpointListener> dispatcher;

    @NotNull
    public Set<T> getBreakpoints() {
        return this.breakpoints;
    }

    @NotNull
    protected final ConcurrentMap<T, T> getBreakpointDuplicationByTarget() {
        return this.breakpointDuplicationByTarget;
    }

    @NotNull
    protected final EventDispatcher<BreakpointListener> getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    protected abstract T createBreakpoint(@NotNull BreakpointTarget var1, int var2, int var3, @Nullable String var4, int var5, boolean var6);

    @NotNull
    protected abstract Promise<? extends Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget var1, @Nullable Url var2, @NotNull T var3);

    @Override
    @NotNull
    public Breakpoint setBreakpoint(@NotNull BreakpointTarget target2, int line, int column, @Nullable Url url, @Nullable String condition2, int ignoreCount, boolean enabled, @Nullable Ref<Promise<? extends Breakpoint>> promiseRef) {
        T breakpoint;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
                breakpoint = this.createBreakpoint(target2, line, column, condition2, ignoreCount, enabled);
                BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
                if (existingBreakpoint != null) {
                    Ref<Promise<? extends Breakpoint>> ref = promiseRef;
                    if (ref != null) {
                        ref.set((Object)Promises.resolvedPromise(breakpoint));
                    }
                    return existingBreakpoint;
                }
                this.getBreakpoints().add(breakpoint);
                if (!enabled) break block2;
                Promise promise2 = this.doSetBreakpoint(target2, url, breakpoint).rejected((Consumer)new Consumer<Throwable>(this, (BreakpointBase)breakpoint){
                    final /* synthetic */ BreakpointManagerBase this$0;
                    final /* synthetic */ BreakpointBase $breakpoint;

                    public final void consume(Throwable it) {
                        BreakpointListener breakpointListener = (BreakpointListener)this.this$0.getDispatcher().getMulticaster();
                        Breakpoint breakpoint = this.$breakpoint;
                        String string = it.getMessage();
                        if (string == null) {
                            string = it.toString();
                        }
                        breakpointListener.errorOccurred(breakpoint, string);
                    }
                    {
                        this.this$0 = breakpointManagerBase;
                        this.$breakpoint = breakpointBase;
                    }
                });
                Ref<Promise<? extends Breakpoint>> ref = promiseRef;
                if (ref == null) break block3;
                ref.set((Object)promise2);
                break block3;
            }
            Ref<Promise<? extends Breakpoint>> ref = promiseRef;
            if (ref == null) break block3;
            ref.set((Object)Promises.resolvedPromise(breakpoint));
        }
        return (Breakpoint)breakpoint;
    }

    @Override
    @NotNull
    public final Promise<?> remove(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        BreakpointBase b = (BreakpointBase)breakpoint;
        boolean existed = this.getBreakpoints().remove(b);
        if (existed) {
            this.breakpointDuplicationByTarget.remove(b);
        }
        return !existed || !b.isVmRegistered() ? Promises.nullPromise() : this.doClearBreakpoint(b);
    }

    @Override
    @NotNull
    public final Promise<?> removeAll() {
        List list2 = CollectionsKt.toList((Iterable)this.getBreakpoints());
        this.getBreakpoints().clear();
        this.breakpointDuplicationByTarget.clear();
        SmartList promises = new SmartList();
        for (BreakpointBase b : list2) {
            if (!b.isVmRegistered()) continue;
            BreakpointBase breakpointBase = b;
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpointBase, (String)"b");
            promises.add(this.doClearBreakpoint(breakpointBase));
        }
        return Promises.all((Collection)((Collection)promises));
    }

    @NotNull
    protected abstract Promise<?> doClearBreakpoint(@NotNull T var1);

    @Override
    public final void addBreakpointListener(@NotNull BreakpointListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    protected final void notifyBreakpointResolvedListener(@NotNull T breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        if (((BreakpointBase)breakpoint).isResolved()) {
            ((BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }

    @Override
    @NotNull
    public Promise<?> flush(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return ((BreakpointBase)breakpoint).flush(this);
    }

    @Override
    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        return Promises.rejectedPromise((String)"Unsupported");
    }

    public BreakpointManagerBase() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)new TObjectHashingStrategy<T>(){

            public int computeHashCode(@NotNull T b) {
                Intrinsics.checkParameterIsNotNull(b, (String)"b");
                int result2 = ((BreakpointBase)b).getLine();
                result2 *= 31 + ((BreakpointBase)b).getColumn();
                if (((BreakpointBase)b).getCondition() != null) {
                    String string = ((BreakpointBase)b).getCondition();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    result2 *= 31 + string.hashCode();
                }
                return result2 *= 31 + ((BreakpointBase)b).getTarget().hashCode();
            }

            public boolean equals(@NotNull T b1, @NotNull T b2) {
                Intrinsics.checkParameterIsNotNull(b1, (String)"b1");
                Intrinsics.checkParameterIsNotNull(b2, (String)"b2");
                return Intrinsics.areEqual(((BreakpointBase)b1).getTarget().getClass(), ((BreakpointBase)b2).getTarget().getClass()) && Intrinsics.areEqual((Object)((BreakpointBase)b1).getTarget(), (Object)((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && StringUtil.equals((CharSequence)((BreakpointBase)b1).getCondition(), (CharSequence)((BreakpointBase)b2).getCondition());
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurr\u2026ition, b2.condition)\n  })");
        this.breakpointDuplicationByTarget = concurrentMap;
        EventDispatcher eventDispatcher = EventDispatcher.create(BreakpointListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(B\u2026ointListener::class.java)");
        this.dispatcher = eventDispatcher;
    }

    @Override
    public boolean getRegExpBreakpointSupported() {
        return BreakpointManager.DefaultImpls.getRegExpBreakpointSupported(this);
    }

    @Override
    @Nullable
    public Function1<String, BreakpointTarget> getFunctionSupport() {
        return BreakpointManager.DefaultImpls.getFunctionSupport(this);
    }

    @Override
    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager.DefaultImpls.getMuteMode(this);
    }
}

